/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.service.permission;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.NodeTree;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.option.OptionSubjectData;
import org.spongepowered.api.util.Tristate;

public class MemorySubjectData
implements OptionSubjectData {
    private final PermissionService service;
    private final ConcurrentMap<Set<Context>, Map<String, String>> options = Maps.newConcurrentMap();
    private final ConcurrentMap<Set<Context>, NodeTree> permissions = Maps.newConcurrentMap();
    private final ConcurrentMap<Set<Context>, List<Map.Entry<String, String>>> parents = Maps.newConcurrentMap();

    public MemorySubjectData(PermissionService service) {
        Preconditions.checkNotNull((Object)service, (Object)"service");
        this.service = service;
    }

    @Override
    public Map<Set<Context>, Map<String, Boolean>> getAllPermissions() {
        ImmutableMap.Builder ret = ImmutableMap.builder();
        for (Map.Entry ent : this.permissions.entrySet()) {
            ret.put(ent.getKey(), ((NodeTree)ent.getValue()).asMap());
        }
        return ret.build();
    }

    public NodeTree getNodeTree(Set<Context> contexts) {
        NodeTree perms = (NodeTree)this.permissions.get(contexts);
        return perms == null ? NodeTree.of(Collections.emptyMap()) : perms;
    }

    @Override
    public Map<String, Boolean> getPermissions(Set<Context> contexts) {
        NodeTree perms = (NodeTree)this.permissions.get(contexts);
        return perms == null ? Collections.emptyMap() : perms.asMap();
    }

    @Override
    public boolean setPermission(Set<Context> contexts, String permission, Tristate value) {
        NodeTree oldTree;
        contexts = ImmutableSet.copyOf(contexts);
        do {
            if ((oldTree = (NodeTree)this.permissions.get(contexts)) == null || oldTree.get(permission) != value) continue;
            return false;
        } while (!(oldTree == null && value != Tristate.UNDEFINED ? this.permissions.putIfAbsent((Set<Context>)contexts, NodeTree.of((Map<String, Boolean>)ImmutableMap.of((Object)permission, (Object)value.asBoolean()))) == null : oldTree == null || this.permissions.replace((Set<Context>)contexts, oldTree, oldTree.withValue(permission, value))));
        return true;
    }

    @Override
    public boolean clearPermissions() {
        boolean wasEmpty = this.permissions.isEmpty();
        this.permissions.clear();
        return !wasEmpty;
    }

    @Override
    public boolean clearPermissions(Set<Context> context) {
        return this.permissions.remove(context) != null;
    }

    @Override
    public Map<Set<Context>, List<Subject>> getAllParents() {
        ImmutableMap.Builder ret = ImmutableMap.builder();
        for (Map.Entry ent : this.parents.entrySet()) {
            ret.put(ent.getKey(), this.toSubjectList((List)ent.getValue()));
        }
        return ret.build();
    }

    List<Subject> toSubjectList(List<Map.Entry<String, String>> parents) {
        ImmutableList.Builder ret = ImmutableList.builder();
        for (Map.Entry<String, String> ent : parents) {
            SubjectCollection collection = this.service.getSubjects(ent.getKey());
            ret.add((Object)collection.get(ent.getValue()));
        }
        return ret.build();
    }

    @Override
    public List<Subject> getParents(Set<Context> contexts) {
        List ret = (List)this.parents.get(contexts);
        return ret == null ? Collections.emptyList() : this.toSubjectList(ret);
    }

    @Override
    public boolean addParent(Set<Context> contexts, Subject parent) {
        ImmutableList newParents;
        List oldParents;
        contexts = ImmutableSet.copyOf(contexts);
        do {
            Map.Entry newEnt = Maps.immutableEntry((Object)parent.getContainingCollection().getIdentifier(), (Object)parent.getIdentifier());
            oldParents = (List)this.parents.get(contexts);
            newParents = ImmutableList.builder().addAll((Iterable)(oldParents == null ? Collections.emptyList() : oldParents)).add((Object)newEnt).build();
            if (oldParents == null || !oldParents.contains(newEnt)) continue;
            return false;
        } while (!this.updateCollection(this.parents, contexts, oldParents, newParents));
        return true;
    }

    private <K, V> boolean updateCollection(ConcurrentMap<K, V> collection, K key, @Nullable V oldValue, V newValue) {
        return oldValue == null ? collection.putIfAbsent(key, newValue) == null : collection.replace(key, oldValue, newValue);
    }

    @Override
    public boolean removeParent(Set<Context> contexts, Subject parent) {
        ArrayList newParents;
        List oldParents;
        contexts = ImmutableSet.copyOf(contexts);
        do {
            Map.Entry removeEnt = Maps.immutableEntry((Object)parent.getContainingCollection().getIdentifier(), (Object)parent.getIdentifier());
            oldParents = (List)this.parents.get(contexts);
            if (oldParents == null || !oldParents.contains(removeEnt)) {
                return false;
            }
            newParents = new ArrayList(oldParents);
            newParents.remove(removeEnt);
        } while (!this.updateCollection(this.parents, contexts, oldParents, Collections.unmodifiableList(newParents)));
        return true;
    }

    @Override
    public boolean clearParents() {
        boolean wasEmpty = this.parents.isEmpty();
        this.parents.clear();
        return !wasEmpty;
    }

    @Override
    public boolean clearParents(Set<Context> contexts) {
        return this.parents.remove(contexts) != null;
    }

    @Override
    public Map<Set<Context>, Map<String, String>> getAllOptions() {
        return ImmutableMap.copyOf(this.options);
    }

    @Override
    public Map<String, String> getOptions(Set<Context> contexts) {
        Map ret = (Map)this.options.get(contexts);
        return ret == null ? ImmutableMap.of() : ImmutableMap.copyOf((Map)ret);
    }

    @Override
    public boolean setOption(Set<Context> contexts, String key, @Nullable String value) {
        Map<String, String> newMap;
        Map<String, String> origMap = (Map<String, String>)this.options.get(contexts);
        if (origMap == null && (origMap = this.options.putIfAbsent((Set<Context>)ImmutableSet.copyOf(contexts), (Map<String, String>)ImmutableMap.of((Object)key.toLowerCase(), (Object)value))) == null) {
            return true;
        }
        do {
            if (value == null) {
                if (!origMap.containsKey(key)) {
                    return false;
                }
                newMap = new HashMap();
                newMap.putAll(origMap);
                newMap.remove(key);
                continue;
            }
            newMap = new HashMap<String, String>();
            newMap.putAll(origMap);
            newMap.put(key, value);
        } while (!this.options.replace(contexts, origMap, newMap = Collections.unmodifiableMap(newMap)));
        return true;
    }

    @Override
    public boolean clearOptions(Set<Context> contexts) {
        return this.options.remove(contexts) != null;
    }

    @Override
    public boolean clearOptions() {
        this.options.clear();
        return true;
    }
}

