/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text.serializer;

import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.text.BookView;
import org.spongepowered.api.text.Text;

public class BookViewDataBuilder
extends AbstractDataBuilder<BookView>
implements TypeSerializer<BookView> {
    private static final String NODE_AUTHOR = "author";
    private static final String NODE_TITLE = "title";
    private static final String NODE_PAGES = "pages";
    private static final TypeToken<Text> TOKEN_TEXT = TypeToken.of(Text.class);
    private static final TypeToken<List<Text>> TOKEN_TEXT_LIST = new TypeToken<List<Text>>(){
        private static final long serialVersionUID = 1L;
    };

    public BookViewDataBuilder() {
        super(BookView.class, 1);
    }

    private Text getText(Object textView) {
        if (!(textView instanceof DataView)) {
            throw new InvalidDataException("Expected DataView");
        }
        return Sponge.getDataManager().deserialize(Text.class, (DataView)textView).get();
    }

    private Optional<Text> findText(DataView container, DataQuery query) {
        if (container.contains(query)) {
            return Optional.of(this.getText(container.get(query).get()));
        }
        return Optional.empty();
    }

    @Override
    protected Optional<BookView> buildContent(DataView container) throws InvalidDataException {
        BookView.Builder builder = BookView.builder();
        this.findText(container, Queries.TEXT_TITLE).ifPresent(builder::title);
        this.findText(container, Queries.TEXT_AUTHOR).ifPresent(builder::author);
        if (container.contains(Queries.TEXT_PAGE_LIST)) {
            Object pageList = container.get(Queries.TEXT_PAGE_LIST).get();
            if (!(pageList instanceof List)) {
                throw new InvalidDataException("Expected List");
            }
            ((List)pageList).forEach(textView -> builder.addPage(this.getText(textView)));
        }
        return Optional.of(builder.build());
    }

    public BookView deserialize(TypeToken<?> type, ConfigurationNode value) throws ObjectMappingException {
        BookView.Builder builder = BookView.builder();
        builder.author((Text)value.getNode(new Object[]{NODE_AUTHOR}).getValue(TOKEN_TEXT));
        builder.title((Text)value.getNode(new Object[]{NODE_TITLE}).getValue(TOKEN_TEXT));
        builder.addPages((Collection)value.getNode(new Object[]{NODE_PAGES}).getValue(TOKEN_TEXT_LIST));
        return builder.build();
    }

    public void serialize(TypeToken<?> type, BookView bookView, ConfigurationNode value) throws ObjectMappingException {
        value.getNode(new Object[]{NODE_AUTHOR}).setValue(TOKEN_TEXT, (Object)bookView.getAuthor());
        value.getNode(new Object[]{NODE_TITLE}).setValue(TOKEN_TEXT, (Object)bookView.getTitle());
        value.getNode(new Object[]{NODE_PAGES}).setValue(TOKEN_TEXT_LIST, bookView.getPages());
    }
}

