/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text.serializer;

import com.google.common.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.gson.GsonConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.MemoryDataContainer;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextParseException;
import org.spongepowered.api.text.serializer.TextSerializers;

public class TextConfigSerializer
extends AbstractDataBuilder<Text>
implements TypeSerializer<Text> {
    public TextConfigSerializer() {
        super(Text.class, 1);
    }

    public Text deserialize(TypeToken<?> type, ConfigurationNode value) throws ObjectMappingException {
        StringWriter writer = new StringWriter();
        GsonConfigurationLoader gsonLoader = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().setSink(() -> new BufferedWriter(writer))).build();
        try {
            gsonLoader.save(value);
        }
        catch (IOException e) {
            throw new ObjectMappingException((Throwable)e);
        }
        return Sponge.getDataManager().deserialize(Text.class, new MemoryDataContainer().set(Queries.JSON, (Object)writer.getBuffer().toString())).get();
    }

    public void serialize(TypeToken<?> type, Text obj, ConfigurationNode value) throws ObjectMappingException {
        String json = (String)obj.toContainer().get(Queries.JSON).get();
        GsonConfigurationLoader gsonLoader = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().setSource(() -> new BufferedReader(new StringReader(json)))).build();
        try {
            value.setValue((Object)gsonLoader.load());
        }
        catch (IOException e) {
            throw new ObjectMappingException((Throwable)e);
        }
    }

    @Override
    protected Optional<Text> buildContent(DataView container) throws InvalidDataException {
        Optional<Object> json = container.get(Queries.JSON);
        if (json.isPresent()) {
            try {
                return Optional.of(TextSerializers.JSON.deserialize(json.get().toString()));
            }
            catch (TextParseException e) {
                throw new InvalidDataException(e);
            }
        }
        return Optional.empty();
    }
}

