/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text.serializer;

import com.google.common.reflect.TypeToken;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.spongepowered.api.GameRegistry;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextFormat;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;

public class TextFormatConfigSerializer
implements TypeSerializer<TextFormat> {
    private static final String NODE_COLOR = "color";
    private static final String NODE_STYLE = "style";

    public TextFormat deserialize(TypeToken<?> type, ConfigurationNode value) throws ObjectMappingException {
        TextColor color = TextColors.NONE;
        GameRegistry registry = Sponge.getRegistry();
        String colorId = value.getNode(new Object[]{NODE_COLOR}).getString();
        if (colorId != null) {
            color = registry.getType(TextColor.class, colorId).orElseThrow(() -> new ObjectMappingException("Color not found: " + colorId));
        }
        TextStyle style = TextStyles.NONE;
        ConfigurationNode styleNode = value.getNode(new Object[]{NODE_STYLE});
        for (TextStyle.Base component : registry.getAllOf(TextStyle.Base.class)) {
            if (!styleNode.getNode(new Object[]{component.getId().toLowerCase()}).getBoolean()) continue;
            style = style.and(component);
        }
        return TextFormat.NONE.color(color).style(style);
    }

    public void serialize(TypeToken<?> type, TextFormat obj, ConfigurationNode value) throws ObjectMappingException {
        value.getNode(new Object[]{NODE_COLOR}).setValue((Object)obj.getColor().getId());
        ConfigurationNode styleNode = value.getNode(new Object[]{NODE_STYLE});
        TextStyle composite = obj.getStyle();
        Sponge.getRegistry().getAllOf(TextStyle.Base.class).forEach(style -> styleNode.getNode(new Object[]{style.getId().toLowerCase()}).setValue((Object)composite.contains((TextStyle)style)));
    }
}

