/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text.serializer;

import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextTemplate;
import org.spongepowered.api.text.format.TextFormat;

public class TextTemplateConfigSerializer
implements TypeSerializer<TextTemplate> {
    private static final String NODE_CONTENT = "content";
    private static final String NODE_ARGS = "arguments";
    private static final String NODE_OPT = "optional";
    private static final String NODE_DEF_VAL = "defaultValue";
    private static final String NODE_OPTIONS = "options";
    private static final String NODE_OPEN_ARG = "openArg";
    private static final String NODE_CLOSE_ARG = "closeArg";
    private static final TypeToken<Text> TOKEN_TEXT = TypeToken.of(Text.class);
    private static final TypeToken<Map<String, TextTemplate.Arg>> TOKEN_ARGS = new TypeToken<Map<String, TextTemplate.Arg>>(){
        private static final long serialVersionUID = 1L;
    };
    private ConfigurationNode root;
    private String openArg;
    private String closeArg;

    public TextTemplate deserialize(TypeToken<?> type, ConfigurationNode value) throws ObjectMappingException {
        this.root = value;
        this.openArg = value.getNode(new Object[]{NODE_OPEN_ARG}).getString("{");
        this.closeArg = value.getNode(new Object[]{NODE_CLOSE_ARG}).getString("}");
        Text content = (Text)value.getNode(new Object[]{NODE_CONTENT}).getValue(TypeToken.of(Text.class));
        ArrayList<Object> elements = new ArrayList<Object>();
        this.parse(content, elements);
        return TextTemplate.of(elements.toArray(new Object[elements.size()]));
    }

    public void serialize(TypeToken<?> type, TextTemplate obj, ConfigurationNode value) throws ObjectMappingException {
        value.getNode(new Object[]{NODE_OPTIONS, NODE_OPEN_ARG}).setValue((Object)obj.getOpenArgString());
        value.getNode(new Object[]{NODE_OPTIONS, NODE_CLOSE_ARG}).setValue((Object)obj.getCloseArgString());
        value.getNode(new Object[]{NODE_ARGS}).setValue(TOKEN_ARGS, obj.getArguments());
        value.getNode(new Object[]{NODE_CONTENT}).setValue(TOKEN_TEXT, (Object)obj.toText());
    }

    private void parse(Text content, List<Object> into) throws ObjectMappingException {
        if (this.isArg(content)) {
            this.parseArg((LiteralText)content, into);
        } else {
            into.add(content.toBuilder().removeAll().build());
        }
        for (Text child : content.getChildren()) {
            this.parse(child, into);
        }
    }

    private void parseArg(LiteralText source, List<Object> into) throws ObjectMappingException {
        String name = this.unwrap(source.getContent());
        boolean optional = this.root.getNode(new Object[]{NODE_ARGS, name, NODE_OPT}).getBoolean();
        Text defaultValue = (Text)this.root.getNode(new Object[]{NODE_ARGS, name, NODE_DEF_VAL}).getValue(TypeToken.of(Text.class));
        TextFormat format = source.getFormat();
        into.add(TextTemplate.arg(name).format(format).optional(optional).defaultValue(defaultValue).build());
    }

    private boolean isArg(Text element) {
        if (!(element instanceof LiteralText)) {
            return false;
        }
        String literal = ((LiteralText)element).getContent();
        return literal.startsWith(this.openArg) && literal.endsWith(this.closeArg) && this.isArgDefined(this.unwrap(literal));
    }

    private String unwrap(String str) {
        return str.substring(this.openArg.length(), str.length() - this.closeArg.length());
    }

    private boolean isArgDefined(String argName) {
        return !this.root.getNode(new Object[]{NODE_ARGS, argName}).isVirtual();
    }
}

