/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3f;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.MemoryDataContainer;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.type.DyeColor;

public final class Color
implements DataSerializable {
    private static final int MASK = 255;
    public static final Color BLACK = Color.ofRgb(0);
    public static final Color GRAY = Color.ofRgb(0x808080);
    public static final Color WHITE = Color.ofRgb(0xFFFFFF);
    public static final Color BLUE = Color.ofRgb(255);
    public static final Color GREEN = Color.ofRgb(32768);
    public static final Color LIME = Color.ofRgb(65280);
    public static final Color RED = Color.ofRgb(0xFF0000);
    public static final Color YELLOW = Color.ofRgb(0xFFFF00);
    public static final Color MAGENTA = Color.ofRgb(0xFF00FF);
    public static final Color PURPLE = Color.ofRgb(0xAA00FF);
    public static final Color DARK_CYAN = Color.ofRgb(35723);
    public static final Color DARK_GREEN = Color.ofRgb(25600);
    public static final Color DARK_MAGENTA = Color.ofRgb(0x8B008B);
    public static final Color CYAN = Color.ofRgb(65535);
    public static final Color NAVY = Color.ofRgb(128);
    public static final Color PINK = Color.ofRgb(0xFF00AA);
    private final byte red;
    private final byte green;
    private final byte blue;
    private final int rgb;

    public static Color ofRgb(int hex) {
        return Color.ofRgb(hex >> 16 & 0xFF, hex >> 8 & 0xFF, hex & 0xFF);
    }

    public static Color ofRgb(int red, int green, int blue) {
        return new Color(red, green, blue);
    }

    public static Color of(java.awt.Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Color of(Vector3i vector3i) {
        return new Color(vector3i.getX(), vector3i.getY(), vector3i.getZ());
    }

    public static Color of(Vector3f vector3f) {
        return new Color(Math.round(vector3f.getX()), Math.round(vector3f.getY()), Math.round(vector3f.getZ()));
    }

    public static Color of(Vector3d vector3d) {
        return new Color((int)Math.round(vector3d.getX()), (int)Math.round(vector3d.getY()), (int)Math.round(vector3d.getZ()));
    }

    public static Color mixDyeColors(DyeColor ... colors) {
        Validate.noNullElements((Object[])colors, (String)"No nulls allowed!", (Object[])new Object[0]);
        Color[] actualColors = new Color[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            actualColors[i] = colors[i].getColor();
        }
        return Color.mixColors(actualColors);
    }

    public static Color mixColors(Color ... colors) {
        Validate.noNullElements((Object[])colors, (String)"No null colors allowed!", (Object[])new Object[0]);
        Preconditions.checkArgument((colors.length > 0 ? 1 : 0) != 0, (Object)"Cannot have an empty color array!");
        if (colors.length == 1) {
            return colors[0];
        }
        int red = colors[0].getRed();
        int green = colors[0].getGreen();
        int blue = colors[0].getBlue();
        for (int i = 1; i < colors.length; ++i) {
            red += colors[i].getRed();
            green += colors[i].getGreen();
            blue += colors[i].getBlue();
        }
        int averageRed = Math.round((float)red / (float)colors.length);
        int averageGreen = Math.round((float)green / (float)colors.length);
        int averageBlue = Math.round((float)blue / (float)colors.length);
        return Color.ofRgb(averageRed, averageGreen, averageBlue);
    }

    private Color(int red, int green, int blue) {
        this.red = (byte)(red & 0xFF);
        this.green = (byte)(green & 0xFF);
        this.blue = (byte)(blue & 0xFF);
        this.rgb = (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | (this.blue & 0xFF) << 0;
    }

    public int getRed() {
        return 0xFF & this.red;
    }

    public Color withRed(int red) {
        return Color.ofRgb(red, this.getGreen(), this.getBlue());
    }

    public int getGreen() {
        return 0xFF & this.green;
    }

    public Color withGreen(int green) {
        return Color.ofRgb(this.getRed(), green, this.getBlue());
    }

    public int getBlue() {
        return 0xFF & this.blue;
    }

    public Color withBlue(int blue) {
        return Color.ofRgb(this.getRed(), this.getGreen(), blue);
    }

    public java.awt.Color asJavaColor() {
        return new java.awt.Color(this.getRed(), this.getGreen(), this.getBlue());
    }

    public int getRgb() {
        return this.rgb;
    }

    public Color mixWithColors(Color ... colors) {
        Color[] newColorArray = new Color[colors.length + 1];
        newColorArray[0] = this;
        System.arraycopy(colors, 0, newColorArray, 1, colors.length);
        return Color.mixColors(newColorArray);
    }

    public Color mixWithDyes(DyeColor ... dyeColors) {
        Color[] newColorArray = new Color[dyeColors.length + 1];
        newColorArray[0] = this;
        for (int i = 0; i < dyeColors.length; ++i) {
            newColorArray[i + 1] = dyeColors[i].getColor();
        }
        return Color.mixColors(newColorArray);
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return new MemoryDataContainer().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Queries.COLOR_RED, (Object)this.getRed()).set(Queries.COLOR_GREEN, (Object)this.getGreen()).set(Queries.COLOR_BLUE, (Object)this.getBlue());
    }

    public int hashCode() {
        return Objects.hash(Color.class, this.red, this.green, this.blue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Color other = (Color)obj;
        return this.red == other.red && this.green == other.green && this.blue == other.blue;
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("red", this.getRed()).add("green", this.getGreen()).add("blue", this.getBlue()).toString();
    }

    public static final class Builder
    extends AbstractDataBuilder<Color>
    implements DataBuilder<Color> {
        public Builder() {
            super(Color.class, 1);
        }

        @Override
        protected Optional<Color> buildContent(DataView container) throws InvalidDataException {
            if (!container.contains(Queries.COLOR_RED, Queries.COLOR_GREEN, Queries.COLOR_BLUE)) {
                return Optional.empty();
            }
            try {
                int red = container.getInt(Queries.COLOR_RED).get();
                int green = container.getInt(Queries.COLOR_GREEN).get();
                int blue = container.getInt(Queries.COLOR_BLUE).get();
                return Optional.of(Color.ofRgb(red, green, blue));
            }
            catch (Exception e) {
                throw new InvalidDataException("Could not parse some data.", e);
            }
        }
    }
}

