/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util.blockray;

import com.flowpowered.math.GenericMath;
import com.flowpowered.math.imaginary.Quaterniond;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.property.entity.EyeLocationProperty;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.util.Functional;
import org.spongepowered.api.util.blockray.BlockRayHit;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public class BlockRay<E extends Extent>
implements Iterator<BlockRayHit<E>> {
    private static final Predicate ONLY_AIR_FILTER = BlockRay.blockTypeFilter(BlockTypes.AIR);
    static final Predicate ALL_FILTER = input -> true;
    private static final Vector3d X_POSITIVE = Vector3d.UNIT_X;
    private static final Vector3d X_NEGATIVE = X_POSITIVE.negate();
    private static final Vector3d Y_POSITIVE = Vector3d.UNIT_Y;
    private static final Vector3d Y_NEGATIVE = Y_POSITIVE.negate();
    private static final Vector3d Z_POSITIVE = Vector3d.UNIT_Z;
    private static final Vector3d Z_NEGATIVE = Z_POSITIVE.negate();
    private static final int DEFAULT_BLOCK_LIMIT = 1000;
    private final Predicate<BlockRayHit<E>> filter;
    private final E extent;
    private final Vector3d position;
    private final Vector3d direction;
    private final Vector3d xNormal;
    private final Vector3d yNormal;
    private final Vector3d zNormal;
    private Vector3d xyzNormal;
    private Vector3d xyNormal;
    private Vector3d xzNormal;
    private Vector3d yzNormal;
    private final int xPlaneIncrement;
    private final int yPlaneIncrement;
    private final int zPlaneIncrement;
    private double xCurrent;
    private double yCurrent;
    private double zCurrent;
    private Vector3d normalCurrent;
    private int xPlaneNext;
    private int yPlaneNext;
    private int zPlaneNext;
    private double xPlaneT;
    private double yPlaneT;
    private double zPlaneT;
    private int blockLimit = 1000;
    private int blockCount;
    private BlockRayHit<E> hit;
    private boolean ahead;

    BlockRay(Predicate<BlockRayHit<E>> filter, E extent, Vector3d position, Vector3d direction) {
        Preconditions.checkArgument((direction.lengthSquared() != 0.0 ? 1 : 0) != 0, (Object)"Direction cannot be the zero vector");
        this.filter = filter;
        this.extent = extent;
        this.position = position;
        this.direction = direction;
        if (this.direction.getX() >= 0.0) {
            this.xPlaneIncrement = 1;
            this.xNormal = X_NEGATIVE;
        } else {
            this.xPlaneIncrement = -1;
            this.xNormal = X_POSITIVE;
        }
        if (this.direction.getY() >= 0.0) {
            this.yPlaneIncrement = 1;
            this.yNormal = Y_NEGATIVE;
        } else {
            this.yPlaneIncrement = -1;
            this.yNormal = Y_POSITIVE;
        }
        if (this.direction.getZ() >= 0.0) {
            this.zPlaneIncrement = 1;
            this.zNormal = Z_NEGATIVE;
        } else {
            this.zPlaneIncrement = -1;
            this.zNormal = Z_POSITIVE;
        }
        this.reset();
    }

    public void setBlockLimit(int blockLimit) {
        this.blockLimit = blockLimit;
    }

    public final void reset() {
        this.xCurrent = this.position.getX();
        this.yCurrent = this.position.getY();
        this.zCurrent = this.position.getZ();
        this.xPlaneNext = GenericMath.floor((double)this.xCurrent);
        this.yPlaneNext = GenericMath.floor((double)this.yCurrent);
        this.zPlaneNext = GenericMath.floor((double)this.zCurrent);
        if (this.xCurrent - (double)this.xPlaneNext != 0.0 && this.direction.getX() >= 0.0) {
            ++this.xPlaneNext;
        }
        if (this.yCurrent - (double)this.yPlaneNext != 0.0 && this.direction.getY() >= 0.0) {
            ++this.yPlaneNext;
        }
        if (this.zCurrent - (double)this.zPlaneNext != 0.0 && this.direction.getZ() >= 0.0) {
            ++this.zPlaneNext;
        }
        this.xPlaneT = ((double)this.xPlaneNext - this.position.getX()) / this.direction.getX();
        this.yPlaneT = ((double)this.yPlaneNext - this.position.getY()) / this.direction.getY();
        this.zPlaneT = ((double)this.zPlaneNext - this.position.getZ()) / this.direction.getZ();
        this.normalCurrent = Vector3d.ZERO;
        this.blockCount = 0;
        this.ahead = false;
        this.hit = null;
    }

    @Override
    public boolean hasNext() {
        if (this.ahead) {
            return true;
        }
        try {
            this.advance();
            this.ahead = true;
            return true;
        }
        catch (NoSuchElementException exception) {
            return false;
        }
    }

    @Override
    public BlockRayHit<E> next() {
        if (this.ahead) {
            this.ahead = false;
        } else {
            this.advance();
        }
        return this.hit;
    }

    public Optional<BlockRayHit<E>> end() {
        while (this.hasNext()) {
            this.next();
        }
        return Optional.ofNullable(this.hit);
    }

    private void advance() {
        if (this.blockLimit >= 0 && this.blockCount >= this.blockLimit) {
            this.hit = null;
            throw new NoSuchElementException("Block limit reached");
        }
        if (this.direction.getX() == 0.0) {
            if (this.direction.getY() == 0.0) {
                this.zIntersect();
            } else if (this.direction.getZ() == 0.0) {
                this.yIntersect();
            } else {
                this.solveIntersections();
            }
        } else if (this.direction.getY() == 0.0) {
            if (this.direction.getZ() == 0.0) {
                this.xIntersect();
            } else {
                this.solveIntersections();
            }
        } else {
            this.solveIntersections();
        }
        BlockRayHit<E> hit = new BlockRayHit<E>(this.extent, this.xCurrent, this.yCurrent, this.zCurrent, this.direction, this.normalCurrent);
        if (!this.extent.containsBlock(hit.getBlockX(), hit.getBlockY(), hit.getBlockZ())) {
            this.hit = null;
            throw new NoSuchElementException("Extent limit reached");
        }
        if (!this.filter.test(hit)) {
            throw new NoSuchElementException("Filter limit reached");
        }
        this.hit = hit;
        ++this.blockCount;
    }

    private void solveIntersections() {
        if (this.xPlaneT == this.yPlaneT) {
            if (this.xPlaneT == this.zPlaneT) {
                this.xyzIntersect();
            } else {
                this.xyIntersect();
            }
        } else if (this.xPlaneT == this.zPlaneT) {
            this.xzIntersect();
        } else if (this.yPlaneT == this.zPlaneT) {
            this.yzIntersect();
        } else if (this.xPlaneT < this.yPlaneT) {
            if (this.xPlaneT < this.zPlaneT) {
                this.xIntersect();
            } else {
                this.zIntersect();
            }
        } else if (this.yPlaneT < this.zPlaneT) {
            this.yIntersect();
        } else {
            this.zIntersect();
        }
    }

    private void xyzIntersect() {
        this.xCurrent = this.xPlaneNext;
        this.yCurrent = this.yPlaneNext;
        this.zCurrent = this.zPlaneNext;
        this.normalCurrent = this.getXyzNormal();
        this.xPlaneNext += this.xPlaneIncrement;
        this.yPlaneNext += this.yPlaneIncrement;
        this.zPlaneNext += this.zPlaneIncrement;
        this.xPlaneT = ((double)this.xPlaneNext - this.position.getX()) / this.direction.getX();
        this.yPlaneT = ((double)this.yPlaneNext - this.position.getY()) / this.direction.getY();
        this.zPlaneT = ((double)this.zPlaneNext - this.position.getZ()) / this.direction.getZ();
    }

    private void xyIntersect() {
        this.xCurrent = this.xPlaneNext;
        this.yCurrent = this.yPlaneNext;
        this.zCurrent = this.direction.getZ() * this.xPlaneT + this.position.getZ();
        this.normalCurrent = this.getXyNormal();
        this.xPlaneNext += this.xPlaneIncrement;
        this.yPlaneNext += this.yPlaneIncrement;
        this.xPlaneT = ((double)this.xPlaneNext - this.position.getX()) / this.direction.getX();
        this.yPlaneT = ((double)this.yPlaneNext - this.position.getY()) / this.direction.getY();
    }

    private void xzIntersect() {
        this.xCurrent = this.xPlaneNext;
        this.yCurrent = this.direction.getY() * this.xPlaneT + this.position.getY();
        this.zCurrent = this.zPlaneNext;
        this.normalCurrent = this.getXzNormal();
        this.xPlaneNext += this.xPlaneIncrement;
        this.zPlaneNext += this.zPlaneIncrement;
        this.xPlaneT = ((double)this.xPlaneNext - this.position.getX()) / this.direction.getX();
        this.zPlaneT = ((double)this.zPlaneNext - this.position.getZ()) / this.direction.getZ();
    }

    private void yzIntersect() {
        this.xCurrent = this.direction.getX() * this.yPlaneT + this.position.getX();
        this.yCurrent = this.yPlaneNext;
        this.zCurrent = this.zPlaneNext;
        this.normalCurrent = this.getYzNormal();
        this.yPlaneNext += this.yPlaneIncrement;
        this.zPlaneNext += this.zPlaneIncrement;
        this.yPlaneT = ((double)this.yPlaneNext - this.position.getY()) / this.direction.getY();
        this.zPlaneT = ((double)this.zPlaneNext - this.position.getZ()) / this.direction.getZ();
    }

    private void xIntersect() {
        this.xCurrent = this.xPlaneNext;
        this.yCurrent = this.direction.getY() * this.xPlaneT + this.position.getY();
        this.zCurrent = this.direction.getZ() * this.xPlaneT + this.position.getZ();
        this.normalCurrent = this.xNormal;
        this.xPlaneNext += this.xPlaneIncrement;
        this.xPlaneT = ((double)this.xPlaneNext - this.position.getX()) / this.direction.getX();
    }

    private void yIntersect() {
        this.xCurrent = this.direction.getX() * this.yPlaneT + this.position.getX();
        this.yCurrent = this.yPlaneNext;
        this.zCurrent = this.direction.getZ() * this.yPlaneT + this.position.getZ();
        this.normalCurrent = this.yNormal;
        this.yPlaneNext += this.yPlaneIncrement;
        this.yPlaneT = ((double)this.yPlaneNext - this.position.getY()) / this.direction.getY();
    }

    private void zIntersect() {
        this.xCurrent = this.direction.getX() * this.zPlaneT + this.position.getX();
        this.yCurrent = this.direction.getY() * this.zPlaneT + this.position.getY();
        this.zCurrent = this.zPlaneNext;
        this.normalCurrent = this.zNormal;
        this.zPlaneNext += this.zPlaneIncrement;
        this.zPlaneT = ((double)this.zPlaneNext - this.position.getZ()) / this.direction.getZ();
    }

    private Vector3d getXyzNormal() {
        if (this.xyzNormal == null) {
            this.xyzNormal = this.xNormal.add(this.yNormal).add(this.zNormal).normalize();
        }
        return this.xyzNormal;
    }

    private Vector3d getXyNormal() {
        if (this.xyNormal == null) {
            this.xyNormal = this.xNormal.add(this.yNormal).normalize();
        }
        return this.xyNormal;
    }

    private Vector3d getXzNormal() {
        if (this.xzNormal == null) {
            this.xzNormal = this.xNormal.add(this.zNormal).normalize();
        }
        return this.xzNormal;
    }

    private Vector3d getYzNormal() {
        if (this.yzNormal == null) {
            this.yzNormal = this.yNormal.add(this.zNormal).normalize();
        }
        return this.yzNormal;
    }

    public static <E extends Extent> BlockRayBuilder<E> from(Location<E> start) {
        Preconditions.checkNotNull(start, (Object)"start");
        return BlockRay.from(start.getExtent(), start.getPosition());
    }

    public static <E extends Extent> BlockRayBuilder<E> from(E extent, Vector3d start) {
        Preconditions.checkNotNull(extent, (Object)"extent");
        Preconditions.checkNotNull((Object)start, (Object)"start");
        return new BlockRayBuilder<E>(extent, start);
    }

    public static BlockRayBuilder<World> from(Entity entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"entity");
        Vector3d rotation = entity.getRotation();
        Vector3d direction = Quaterniond.fromAxesAnglesDeg((double)rotation.getX(), (double)(-rotation.getY()), (double)rotation.getZ()).getDirection();
        Location<World> location = entity.getLocation();
        Optional<EyeLocationProperty> data = entity.getProperty(EyeLocationProperty.class);
        Vector3d position = data.isPresent() ? (Vector3d)data.get().getValue() : location.getPosition();
        return BlockRay.from(location.getExtent(), position).direction(direction);
    }

    public static <E extends Extent> Predicate<BlockRayHit<E>> allFilter() {
        return ALL_FILTER;
    }

    public static <E extends Extent> Predicate<BlockRayHit<E>> onlyAirFilter() {
        return ONLY_AIR_FILTER;
    }

    public static <E extends Extent> Predicate<BlockRayHit<E>> blockTypeFilter(BlockType type) {
        return lastHit -> lastHit.getExtent().getBlockType(lastHit.getBlockX(), lastHit.getBlockY(), lastHit.getBlockZ()).equals(type);
    }

    public static <E extends Extent> Predicate<BlockRayHit<E>> maxDistanceFilter(Vector3d start, double distance) {
        double distanceSquared = distance * distance;
        return lastHit -> {
            double deltaZ;
            double deltaY;
            double deltaX = lastHit.getX() - start.getX();
            return deltaX * deltaX + (deltaY = lastHit.getY() - start.getY()) * deltaY + (deltaZ = lastHit.getZ() - start.getZ()) * deltaZ < distanceSquared;
        };
    }

    public static <E extends Extent> Predicate<BlockRayHit<E>> continueAfterFilter(Predicate<BlockRayHit<E>> filter, int numberOfBlocks) {
        return new ContinueAfterFilter<E>(filter, numberOfBlocks);
    }

    private static class TargetBlockFilter<E extends Extent>
    implements Predicate<BlockRayHit<E>> {
        private final Vector3i target;

        TargetBlockFilter(Vector3d target) {
            this.target = target.toInt();
        }

        @Override
        public boolean test(BlockRayHit<E> lastHit) {
            return lastHit.getBlockX() != this.target.getX() || lastHit.getBlockY() != this.target.getY() || lastHit.getBlockZ() != this.target.getZ();
        }
    }

    private static class ContinueAfterFilter<E extends Extent>
    implements Predicate<BlockRayHit<E>> {
        private final Predicate<BlockRayHit<E>> filter;
        final int numberOfBlocks;
        int extraBlockCount = 0;

        public ContinueAfterFilter(Predicate<BlockRayHit<E>> filter, int numberOfBlocks) {
            this.filter = filter;
            this.numberOfBlocks = numberOfBlocks;
        }

        @Override
        public boolean test(BlockRayHit<E> lastHit) {
            if (this.extraBlockCount <= 0) {
                if (!this.filter.test(lastHit)) {
                    this.extraBlockCount = 1;
                }
                return true;
            }
            return this.extraBlockCount++ < this.numberOfBlocks;
        }
    }

    public static class BlockRayBuilder<E extends Extent>
    implements Iterable<BlockRayHit<E>> {
        private final E extent;
        private final Vector3d position;
        private Predicate<BlockRayHit<E>> filter = BlockRay.allFilter();
        private Vector3d direction = null;
        private int blockLimit = 1000;

        BlockRayBuilder(E extent, Vector3d position) {
            this.extent = extent;
            this.position = position;
        }

        public BlockRayBuilder<E> filter(Predicate<BlockRayHit<E>> filter) {
            Preconditions.checkNotNull(filter, (Object)"filter ");
            this.filter = this.filter == ALL_FILTER ? filter : this.filter.and(filter);
            return this;
        }

        @SafeVarargs
        public final BlockRayBuilder<E> filter(Predicate<BlockRayHit<E>> ... filters) {
            Preconditions.checkNotNull(filters, (Object)"filters");
            Predicate<BlockRayHit<E>> filter = filters.length == 1 ? filters[0] : Functional.predicateAnd(filters);
            this.filter = this.filter == ALL_FILTER ? filter : this.filter.and(filter);
            return this;
        }

        public BlockRayBuilder<E> to(Vector3d end) {
            Preconditions.checkState((this.direction == null ? 1 : 0) != 0, (Object)"Direction has already been set");
            Preconditions.checkNotNull((Object)end, (Object)"end");
            Preconditions.checkArgument((!this.position.equals((Object)end) ? 1 : 0) != 0, (Object)"Start and end cannot be equal");
            this.direction = end.sub(this.position).normalize();
            return this.filter((Predicate<BlockRayHit<E>>)new TargetBlockFilter(end));
        }

        public BlockRayBuilder<E> direction(Vector3d direction) {
            Preconditions.checkState((this.direction == null ? 1 : 0) != 0, (Object)"Direction has already been set");
            Preconditions.checkNotNull((Object)direction, (Object)"direction");
            Preconditions.checkArgument((direction.lengthSquared() != 0.0 ? 1 : 0) != 0, (Object)"Direction must be a non-zero vector");
            this.direction = direction.normalize();
            return this;
        }

        public BlockRayBuilder<E> blockLimit(int blockLimit) {
            this.blockLimit = blockLimit;
            return this;
        }

        public BlockRay<E> build() {
            Preconditions.checkState((this.direction != null ? 1 : 0) != 0, (Object)"Either end point or direction needs to be set");
            BlockRay<E> blockRay = new BlockRay<E>(this.filter, this.extent, this.position, this.direction);
            blockRay.setBlockLimit(this.blockLimit);
            return blockRay;
        }

        @Override
        public Iterator<BlockRayHit<E>> iterator() {
            return this.build();
        }

        public Optional<BlockRayHit<E>> end() {
            return this.build().end();
        }
    }
}

