/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util.blockray;

import com.flowpowered.math.GenericMath;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;

public class BlockRayHit<E extends Extent> {
    private final E extent;
    private final double x;
    private final double y;
    private final double z;
    private Vector3d position = null;
    private final int xBlock;
    private final int yBlock;
    private final int zBlock;
    private Vector3i blockPosition = null;
    private final Vector3d direction;
    private final Vector3d normal;
    private Direction[] faces = null;
    private Location<E> location = null;

    public BlockRayHit(E extent, double x, double y, double z, Vector3d direction, Vector3d normal) {
        this.extent = extent;
        this.x = x;
        this.y = y;
        this.z = z;
        this.direction = direction;
        this.normal = normal;
        this.xBlock = GenericMath.floor((double)x) - (normal.getX() > 0.0 ? 1 : 0);
        this.yBlock = GenericMath.floor((double)y) - (normal.getY() > 0.0 ? 1 : 0);
        this.zBlock = GenericMath.floor((double)z) - (normal.getZ() > 0.0 ? 1 : 0);
    }

    public E getExtent() {
        return this.extent;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public Vector3d getPosition() {
        if (this.position == null) {
            this.position = new Vector3d(this.x, this.y, this.z);
        }
        return this.position;
    }

    public int getBlockX() {
        return this.xBlock;
    }

    public int getBlockY() {
        return this.yBlock;
    }

    public int getBlockZ() {
        return this.zBlock;
    }

    public Vector3i getBlockPosition() {
        if (this.blockPosition == null) {
            this.blockPosition = new Vector3i(this.xBlock, this.yBlock, this.zBlock);
        }
        return this.blockPosition;
    }

    public Location<E> getLocation() {
        if (this.location == null) {
            this.location = new Location<E>(this.extent, this.xBlock, this.yBlock, this.zBlock);
        }
        return this.location;
    }

    public Vector3d getDirection() {
        return this.direction;
    }

    public Vector3d getNormal() {
        return this.normal;
    }

    public Direction[] getFaces() {
        if (this.faces == null) {
            this.faces = new Direction[(this.normal.getX() != 0.0 ? 1 : 0) + (this.normal.getY() != 0.0 ? 1 : 0) + (this.normal.getZ() != 0.0 ? 1 : 0)];
            int index = 0;
            if (this.normal.getX() != 0.0) {
                Direction direction = this.faces[index++] = this.normal.getX() > 0.0 ? Direction.EAST : Direction.WEST;
            }
            if (this.normal.getY() != 0.0) {
                Direction direction = this.faces[index++] = this.normal.getY() > 0.0 ? Direction.UP : Direction.DOWN;
            }
            if (this.normal.getZ() != 0.0) {
                this.faces[index] = this.normal.getZ() > 0.0 ? Direction.SOUTH : Direction.NORTH;
            }
        }
        return this.faces;
    }

    public String toString() {
        return "BlockRayHit{" + this.getPosition() + " in " + this.getExtent() + "}";
    }
}

