/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util.generator.event.factory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.spongepowered.api.eventgencore.AccessorFirstStrategy;
import org.spongepowered.api.eventgencore.Property;
import org.spongepowered.api.eventgencore.PropertySearchStrategy;
import org.spongepowered.api.eventgencore.annotation.PropertySettings;
import org.spongepowered.api.eventgencore.annotation.UseField;
import org.spongepowered.api.eventgencore.classwrapper.ClassWrapper;
import org.spongepowered.api.eventgencore.classwrapper.reflection.ReflectionClassWrapper;
import org.spongepowered.api.util.generator.event.factory.EventFactory;
import org.spongepowered.api.util.generator.event.factory.NullPolicy;
import org.spongepowered.api.util.generator.event.factory.plugin.EventFactoryPlugin;

public class ClassGenerator {
    private final PropertySearchStrategy<Class<?>, Method> propertySearch = new AccessorFirstStrategy();
    private NullPolicy nullPolicy = NullPolicy.DISABLE_PRECONDITIONS;
    private final List<String> primitivePropertyExceptions = ImmutableList.of((Object)"cancelled");

    public static void visitBoxingMethod(MethodVisitor mv, Type type) {
        if (type.getSort() == 1) {
            mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
        } else if (type.getSort() == 5) {
            mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
        } else if (type.getSort() == 3) {
            mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
        } else if (type.getSort() == 4) {
            mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
        } else if (type.getSort() == 7) {
            mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
        } else if (type.getSort() == 6) {
            mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
        } else if (type.getSort() == 8) {
            mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
        } else if (type.getSort() == 2) {
            mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
        }
    }

    public static void visitUnboxingMethod(MethodVisitor mv, Type type) {
        if (type.getSort() == 1) {
            mv.visitTypeInsn(192, "java/lang/Boolean");
            mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
        } else if (type.getSort() == 5) {
            mv.visitTypeInsn(192, "java/lang/Integer");
            mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
        } else if (type.getSort() == 3) {
            mv.visitTypeInsn(192, "java/lang/Byte");
            mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B", false);
        } else if (type.getSort() == 4) {
            mv.visitTypeInsn(192, "java/lang/Short");
            mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S", false);
        } else if (type.getSort() == 7) {
            mv.visitTypeInsn(192, "java/lang/Long");
            mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
        } else if (type.getSort() == 6) {
            mv.visitTypeInsn(192, "java/lang/Float");
            mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F", false);
        } else if (type.getSort() == 8) {
            mv.visitTypeInsn(192, "java/lang/Double");
            mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D", false);
        } else if (type.getSort() == 2) {
            mv.visitTypeInsn(192, "java/lang/Character");
            mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
        } else {
            mv.visitTypeInsn(192, type.getInternalName());
        }
    }

    private static PropertySettings getPropertySettings(Property<Class<?>, Method> property) {
        return ((Method)property.getAccessor()).getAnnotation(PropertySettings.class);
    }

    private static boolean isRequired(Property<Class<?>, Method> property) {
        PropertySettings settings = ClassGenerator.getPropertySettings(property);
        if (settings != null) {
            return settings.requiredParameter();
        }
        return true;
    }

    private static boolean generateMethods(Property<Class<?>, Method> property) {
        PropertySettings settings = ClassGenerator.getPropertySettings(property);
        if (settings != null) {
            return settings.generateMethods();
        }
        return true;
    }

    private static UseField getUseField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName).getAnnotation(UseField.class);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static boolean hasDeclaredMethod(Class<?> type, String name, Class<?> ... params) {
        while (type != null) {
            try {
                type.getDeclaredMethod(name, params);
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                type = type.getSuperclass();
            }
        }
        return false;
    }

    public static Field getField(Class<?> type, String fieldName) {
        while (type != null) {
            try {
                return type.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                type = type.getSuperclass();
            }
        }
        return null;
    }

    public NullPolicy getNullPolicy() {
        return this.nullPolicy;
    }

    public void setNullPolicy(NullPolicy nullPolicy) {
        Preconditions.checkNotNull((Object)((Object)nullPolicy), (Object)"nullPolicy");
        this.nullPolicy = nullPolicy;
    }

    private boolean hasNullable(Method method) {
        return method.getAnnotation(Nullable.class) != null;
    }

    private boolean hasNonnull(Method method) {
        return method.getAnnotation(Nonnull.class) != null;
    }

    public static void generateField(ClassWriter classWriter, Property<Class<?>, Method> property) {
        FieldVisitor fv = classWriter.visitField(2, property.getName(), Type.getDescriptor((Class)((Class)property.getType())), null, null);
        fv.visitEnd();
    }

    private void contributeField(ClassWriter classWriter, Class<?> parentType, Property<Class<?>, Method> property) {
        if (property.isLeastSpecificType()) {
            Field field = ClassGenerator.getField(parentType, property.getName());
            if (field == null || field.getAnnotation(UseField.class) == null) {
                ClassGenerator.generateField(classWriter, property);
            } else {
                if ((field.getModifiers() & 2) != 0) {
                    throw new RuntimeException("You've annotated the field " + property.getName() + " with @SetField, " + "but it's private. This just won't work.");
                }
                if (!((Class)property.getType()).isAssignableFrom((Class)property.getType())) {
                    throw new RuntimeException("You've specified a field of type " + field.getType().getCanonicalName() + "but the property has the type of " + ((Class)property.getType()).getCanonicalName());
                }
            }
        }
    }

    private void generateConstructor(ClassWriter classWriter, String internalName, Class<?> parentType, ImmutableSet<? extends Property<Class<?>, Method>> properties) {
        MethodVisitor mv = classWriter.visitMethod(1, "<init>", "(Ljava/util/Map;)V", "(Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(parentType), "<init>", "()V", false);
        for (Property property : properties) {
            if (!property.isLeastSpecificType()) continue;
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn((Object)property.getName());
            mv.visitMethodInsn(185, "java/util/Map", "remove", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
            mv.visitVarInsn(58, 2);
            if (this.nullPolicy != NullPolicy.DISABLE_PRECONDITIONS) {
                boolean useNullTest;
                boolean bl = useNullTest = (this.nullPolicy == NullPolicy.NON_NULL_BY_DEFAULT && !this.hasNullable((Method)property.getAccessor()) || this.nullPolicy == NullPolicy.NULL_BY_DEFAULT && this.hasNonnull((Method)property.getAccessor())) && ClassGenerator.isRequired(property);
                if (useNullTest) {
                    Label afterNullTest = new Label();
                    mv.visitVarInsn(25, 2);
                    mv.visitJumpInsn(199, afterNullTest);
                    mv.visitTypeInsn(187, "java/lang/NullPointerException");
                    mv.visitInsn(89);
                    mv.visitLdcInsn((Object)("The property '" + property.getName() + "' was not provided!"));
                    mv.visitMethodInsn(183, "java/lang/NullPointerException", "<init>", "(Ljava/lang/String;)V", false);
                    mv.visitInsn(191);
                    mv.visitLabel(afterNullTest);
                }
            }
            boolean hasUseField = ClassGenerator.getUseField(parentType, property.getName()) != null;
            Label afterPut = new Label();
            mv.visitVarInsn(25, 2);
            mv.visitJumpInsn(198, afterPut);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 2);
            ClassGenerator.visitUnboxingMethod(mv, Type.getType((Class)((Class)property.getType())));
            if (hasUseField) {
                mv.visitFieldInsn(181, Type.getInternalName(parentType), property.getName(), Type.getDescriptor((Class)((Class)property.getType())));
            } else {
                mv.visitFieldInsn(181, internalName, property.getName(), Type.getDescriptor((Class)((Class)property.getType())));
            }
            mv.visitLabel(afterPut);
        }
        Label afterException = new Label();
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, "java/util/Map", "isEmpty", "()Z", true);
        mv.visitJumpInsn(154, afterException);
        mv.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        mv.visitInsn(89);
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
        mv.visitLdcInsn((Object)"Some parameters are unused: ");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, "java/util/Map", "keySet", "()Ljava/util/Set;", true);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuilder;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        mv.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V", false);
        mv.visitInsn(191);
        mv.visitLabel(afterException);
        if (ClassGenerator.hasDeclaredMethod(parentType, "init", new Class[0])) {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, Type.getInternalName(parentType), "init", "()V", false);
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generateAccessor(ClassWriter cw, Class<?> parentType, String internalName, Property<Class<?>, Method> property) {
        Method accessor = (Method)property.getAccessor();
        MethodVisitor mv = cw.visitMethod(1, accessor.getName(), Type.getMethodDescriptor((Method)accessor), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalName, property.getName(), Type.getDescriptor((Class)((Class)property.getLeastSpecificType())));
        if (!property.isLeastSpecificType()) {
            mv.visitTypeInsn(192, Type.getInternalName((Class)((Class)property.getType())));
        }
        mv.visitInsn(Type.getType((Class)((Class)property.getType())).getOpcode(172));
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public static void generateMutator(ClassWriter cw, Class<?> type, String internalName, String fieldName, Class<?> fieldType, Property<Class<?>, Method> property) {
        Method mutator = (Method)property.getMutator().get();
        MethodVisitor mv = cw.visitMethod(1, mutator.getName(), Type.getMethodDescriptor((Method)mutator), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(Type.getType((Class)((Class)property.getType())).getOpcode(21), 1);
        if (((Method)property.getAccessor()).getReturnType().equals(Optional.class)) {
            mv.visitMethodInsn(184, "java/util/Optional", "ofNullable", "(Ljava/lang/Object;)Ljava/util/Optional;", false);
        }
        if (!((Class)property.getType()).isPrimitive()) {
            Class<?> mostSpecificReturn;
            try {
                mostSpecificReturn = type.getMethod(((Method)property.getAccessor()).getName(), ((Method)property.getAccessor()).getParameterTypes()).getReturnType();
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("If you're seeing this, than something's REALLY wrong");
            }
            Label afterException = new Label();
            mv.visitInsn(89);
            mv.visitJumpInsn(198, afterException);
            mv.visitInsn(89);
            mv.visitTypeInsn(193, Type.getInternalName(mostSpecificReturn));
            mv.visitJumpInsn(154, afterException);
            mv.visitTypeInsn(187, "java/lang/RuntimeException");
            mv.visitInsn(89);
            mv.visitTypeInsn(187, "java/lang/StringBuilder");
            mv.visitInsn(89);
            mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
            mv.visitLdcInsn((Object)("You've attempted to call the method '" + mutator.getName() + "' with an object of type "));
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuilder;", false);
            mv.visitVarInsn(Type.getType((Class)((Class)property.getType())).getOpcode(21), 1);
            mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
            mv.visitMethodInsn(182, "java/lang/Class", "getName", "()Ljava/lang/String;", false);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuilder;", false);
            mv.visitLdcInsn((Object)(", instead of " + mostSpecificReturn.getName() + ". Though you may have been listening for a supertype of this " + "event, it's actually a " + type.getName() + ". You need to ensure that the type of the event is what you think" + " it is, before calling the method (e.g TileEntityChangeEvent#setNewData"));
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuilder;", false);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
            mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;)V", false);
            mv.visitInsn(191);
            mv.visitLabel(afterException);
        }
        mv.visitFieldInsn(181, internalName, property.getName(), Type.getDescriptor((Class)((Class)property.getType())));
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generateAccessorsandMutator(ClassWriter cw, Class<?> type, Class<?> parentType, String internalName, Property<Class<?>, Method> property) {
        if (ClassGenerator.generateMethods(property)) {
            this.generateAccessor(cw, parentType, internalName, property);
            Optional mutatorOptional = property.getMutator();
            if (mutatorOptional.isPresent()) {
                ClassGenerator.generateMutator(cw, type, internalName, property.getName(), (Class)property.getType(), property);
            }
        }
    }

    private MethodVisitor initializeToString(ClassWriter cw, Class<?> type) {
        MethodVisitor toStringMv = cw.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        toStringMv.visitCode();
        toStringMv.visitTypeInsn(187, "java/lang/StringBuilder");
        toStringMv.visitInsn(89);
        toStringMv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
        toStringMv.visitLdcInsn((Object)(type.getName() + "{"));
        toStringMv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuilder;", false);
        toStringMv.visitVarInsn(58, 1);
        return toStringMv;
    }

    private void contributeToString(String internalName, Property<Class<?>, Method> property, MethodVisitor toStringMv) {
        if (property.isLeastSpecificType()) {
            Type returnType = Type.getReturnType((Method)((Method)property.getAccessor()));
            toStringMv.visitVarInsn(25, 0);
            toStringMv.visitVarInsn(25, 1);
            toStringMv.visitLdcInsn((Object)property.getName());
            toStringMv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuilder;", false);
            toStringMv.visitLdcInsn((Object)"=");
            toStringMv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuilder;", false);
            toStringMv.visitVarInsn(25, 0);
            toStringMv.visitMethodInsn(183, internalName, ((Method)property.getAccessor()).getName(), Type.getMethodDescriptor((Method)((Method)property.getAccessor())), false);
            String desc = ((Class)property.getType()).isPrimitive() ? Type.getDescriptor((Class)((Class)property.getType())) : "Ljava/lang/Object;";
            toStringMv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(" + desc + ")Ljava/lang/StringBuilder;", false);
            toStringMv.visitLdcInsn((Object)", ");
            toStringMv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuilder;", false);
        }
    }

    private void finalizeToString(MethodVisitor mv) {
        mv.visitVarInsn(25, 1);
        mv.visitInsn(89);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "length", "()I", false);
        mv.visitLdcInsn((Object)2);
        mv.visitInsn(100);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "length", "()I", false);
        mv.visitLdcInsn((Object)"}");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "replace", "(IILjava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public static String getInternalName(String name) {
        return name.replace('.', '/');
    }

    public byte[] createClass(Class<?> type, String name, Class<?> parentType, List<? extends EventFactoryPlugin> plugins) {
        Preconditions.checkNotNull(type, (Object)"type");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull(parentType, (Object)"parentType");
        ImmutableSet properties = this.propertySearch.findProperties((ClassWrapper)new ReflectionClassWrapper(type));
        String internalName = ClassGenerator.getInternalName(name);
        ClassWriter cw = new ClassWriter(3);
        cw.visit(50, 33, internalName, null, Type.getInternalName(parentType), new String[]{Type.getInternalName(type)});
        MethodVisitor toStringMv = this.initializeToString(cw, type);
        this.generateWithPlugins(cw, type, parentType, internalName, properties, toStringMv, plugins);
        this.generateConstructor(cw, internalName, parentType, properties);
        this.finalizeToString(toStringMv);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void generateWithPlugins(ClassWriter cw, Class<?> eventClass, Class<?> parentType, String internalName, ImmutableSet<? extends Property<Class<?>, Method>> properties, MethodVisitor toStringMv, List<? extends EventFactoryPlugin> plugins) {
        for (Property property : properties) {
            EventFactoryPlugin plugin;
            boolean processed = false;
            Iterator<? extends EventFactoryPlugin> iterator = plugins.iterator();
            while (iterator.hasNext() && !(processed = (plugin = iterator.next()).contributeProperty(eventClass, internalName, cw, property))) {
            }
            this.contributeToString(internalName, property, toStringMv);
            if (processed) continue;
            this.contributeField(cw, parentType, property);
            this.generateAccessorsandMutator(cw, eventClass, parentType, internalName, property);
        }
    }

    public byte[] createFactory(Class<?> type, String name) {
        Preconditions.checkNotNull(type, (Object)"type");
        String internalName = name.replace('.', '/');
        ClassWriter cw = new ClassWriter(3);
        cw.visit(50, 33, internalName, null, "java/lang/Object", new String[]{Type.getInternalName(EventFactory.class)});
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "apply", "(Ljava/util/Map;)" + Type.getDescriptor(type), "(Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;)" + Type.getDescriptor(type), null);
        mv.visitCode();
        mv.visitTypeInsn(187, Type.getInternalName(type));
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, Type.getInternalName(type), "<init>", "(Ljava/util/Map;)V", false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(4161, "apply", "(Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, "java/util/Map");
        mv.visitMethodInsn(182, internalName, "apply", "(Ljava/util/Map;)" + Type.getDescriptor(type), false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }
}

