/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util.generator.event.factory.plugin;

import java.lang.reflect.Method;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.spongepowered.api.eventgencore.Property;
import org.spongepowered.api.util.annotation.TransformResult;
import org.spongepowered.api.util.annotation.TransformWith;
import org.spongepowered.api.util.generator.event.factory.ClassGenerator;
import org.spongepowered.api.util.generator.event.factory.plugin.EventFactoryPlugin;

public class AccessorModifierEventFactoryPlugin
implements EventFactoryPlugin {
    private MethodPair getLinkedField(Property<Class<?>, Method> property) {
        Method leastSpecificMethod = (Method)property.getLeastSpecificMethod();
        Method transformWith = null;
        String name = null;
        TransformResult transformResult = leastSpecificMethod.getAnnotation(TransformResult.class);
        if (transformResult != null) {
            name = transformResult.value();
            for (Method method : ((Method)property.getAccessor()).getReturnType().getMethods()) {
                TransformWith annotation = method.getAnnotation(TransformWith.class);
                if (annotation == null || !annotation.value().equals(name)) continue;
                if (transformWith != null) {
                    throw new RuntimeException("Multiple @TransformResult annotations were found with the name " + name + ". One of them needs to be changed!");
                }
                transformWith = method;
            }
            if (transformWith == null) {
                throw new RuntimeException("Unable to locate a matching @TransformWith annotation with the name " + name + " for the method" + property.getAccessor());
            }
        }
        if (transformWith != null) {
            return new MethodPair(name, leastSpecificMethod, transformWith, property);
        }
        return null;
    }

    private void generateTransformingAccessor(ClassWriter cw, String internalName, MethodPair pair, Property<Class<?>, Method> property) {
        Method accessor = (Method)property.getAccessor();
        MethodVisitor mv = cw.visitMethod(1, accessor.getName(), Type.getMethodDescriptor((Method)accessor), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalName, property.getName(), Type.getDescriptor((Class)((Class)property.getLeastSpecificType())));
        Method transformerMethod = pair.getTransformerMethod();
        int opcode = 182;
        if (transformerMethod.getDeclaringClass().isInterface()) {
            opcode = 185;
        }
        mv.visitMethodInsn(opcode, Type.getInternalName(transformerMethod.getDeclaringClass()), transformerMethod.getName(), Type.getMethodDescriptor((Method)transformerMethod), opcode != 182);
        mv.visitInsn(Type.getType((Class)((Class)property.getType())).getOpcode(172));
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    @Override
    public boolean contributeProperty(Class<?> eventClass, String internalName, ClassWriter classWriter, Property<Class<?>, Method> property) {
        MethodPair methodPair = this.getLinkedField(property);
        if (methodPair == null) {
            return false;
        }
        ClassGenerator.generateField(classWriter, property);
        if (property.getMutator().isPresent()) {
            ClassGenerator.generateMutator(classWriter, eventClass, internalName, property.getName(), (Class)property.getType(), property);
        }
        this.generateTransformingAccessor(classWriter, internalName, methodPair, property);
        return true;
    }

    private static final class MethodPair {
        private final String name;
        private Method callerMethod;
        private Method transformerMethod;
        private Property<Class<?>, Method> property;

        public MethodPair(String name, Method callerMethod, Method transformerMethod, Property<Class<?>, Method> property) {
            this.name = name;
            this.callerMethod = callerMethod;
            this.transformerMethod = transformerMethod;
            this.property = property;
        }

        public String getName() {
            return this.name;
        }

        public Method getTransformerMethod() {
            return this.transformerMethod;
        }

        public Property<Class<?>, Method> getProperty() {
            return this.property;
        }
    }
}

