/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.effect.Viewer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.context.ContextSource;
import org.spongepowered.api.text.channel.ChatTypeMessageReceiver;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.api.world.Dimension;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.PortalAgent;
import org.spongepowered.api.world.WorldBorder;
import org.spongepowered.api.world.WorldCreationSettings;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.extent.worker.MutableBiomeAreaWorker;
import org.spongepowered.api.world.extent.worker.MutableBlockVolumeWorker;
import org.spongepowered.api.world.gen.WorldGenerator;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.api.world.storage.WorldStorage;
import org.spongepowered.api.world.weather.WeatherUniverse;

public interface World
extends Extent,
WeatherUniverse,
Viewer,
ContextSource,
MessageReceiver,
ChatTypeMessageReceiver {
    default public Location<World> getLocation(Vector3i position) {
        return new Location<World>(this, position);
    }

    default public Location<World> getLocation(int x, int y, int z) {
        return this.getLocation(new Vector3i(x, y, z));
    }

    default public Location<World> getLocation(Vector3d position) {
        return new Location<World>(this, position);
    }

    default public Location<World> getLocation(double x, double y, double z) {
        return this.getLocation(new Vector3d(x, y, z));
    }

    public Difficulty getDifficulty();

    public String getName();

    default public Optional<Chunk> getChunkAtBlock(Vector3i blockPosition) {
        return this.getChunkAtBlock(blockPosition.getX(), blockPosition.getY(), blockPosition.getZ());
    }

    default public Optional<Chunk> getChunkAtBlock(int bx, int by, int bz) {
        return this.getChunk(Sponge.getServer().getChunkLayout().forceToChunk(bx, by, bz));
    }

    default public Optional<Chunk> getChunk(Vector3i chunkPosition) {
        return this.getChunk(chunkPosition.getX(), chunkPosition.getY(), chunkPosition.getZ());
    }

    public Optional<Chunk> getChunk(int var1, int var2, int var3);

    public Optional<Chunk> loadChunk(Vector3i var1, boolean var2);

    public Optional<Chunk> loadChunk(int var1, int var2, int var3, boolean var4);

    public boolean unloadChunk(Chunk var1);

    public Iterable<Chunk> getLoadedChunks();

    public Optional<Entity> getEntity(UUID var1);

    public WorldBorder getWorldBorder();

    public WorldBorder.ChunkPreGenerate newChunkPreGenerate(Vector3d var1, double var2);

    public Optional<String> getGameRule(String var1);

    public Map<String, String> getGameRules();

    public Dimension getDimension();

    public WorldGenerator getWorldGenerator();

    public boolean doesKeepSpawnLoaded();

    public void setKeepSpawnLoaded(boolean var1);

    public WorldStorage getWorldStorage();

    public WorldCreationSettings getCreationSettings();

    public WorldProperties getProperties();

    public Location<World> getSpawnLocation();

    public void triggerExplosion(Explosion var1);

    public PortalAgent getPortalAgent();

    @Override
    public MutableBiomeAreaWorker<? extends World> getBiomeWorker();

    @Override
    public MutableBlockVolumeWorker<? extends World> getBlockWorker();

    public boolean spawnEntities(Iterable<? extends Entity> var1, Cause var2);
}

