/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import java.util.Collection;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.GeneratorType;
import org.spongepowered.api.world.PortalAgentType;
import org.spongepowered.api.world.gen.WorldGeneratorModifier;
import org.spongepowered.api.world.storage.WorldProperties;

public interface WorldCreationSettings {
    public static Builder builder() {
        return Sponge.getGame().getRegistry().createBuilder(Builder.class);
    }

    public String getWorldName();

    public boolean isEnabled();

    public boolean loadOnStartup();

    public boolean doesKeepSpawnLoaded();

    public boolean doesGenerateSpawnOnLoad();

    public long getSeed();

    public GameMode getGameMode();

    public GeneratorType getGeneratorType();

    public Collection<WorldGeneratorModifier> getGeneratorModifiers();

    public boolean usesMapFeatures();

    public boolean isHardcore();

    public boolean commandsAllowed();

    public boolean bonusChestEnabled();

    public DimensionType getDimensionType();

    public PortalAgentType getPortalAgentType();

    public boolean isPVPEnabled();

    public DataContainer getGeneratorSettings();

    public static interface Builder
    extends ResettableBuilder<WorldCreationSettings, Builder> {
        public Builder fill(WorldCreationSettings var1);

        public Builder fill(WorldProperties var1);

        public Builder name(String var1);

        public Builder enabled(boolean var1);

        public Builder loadsOnStartup(boolean var1);

        public Builder keepsSpawnLoaded(boolean var1);

        public Builder generateSpawnOnLoad(boolean var1);

        public Builder seed(long var1);

        public Builder gameMode(GameMode var1);

        public Builder generator(GeneratorType var1);

        public Builder generatorModifiers(WorldGeneratorModifier ... var1);

        public Builder dimension(DimensionType var1);

        public Builder usesMapFeatures(boolean var1);

        public Builder hardcore(boolean var1);

        public Builder generatorSettings(DataContainer var1);

        public Builder portalAgent(PortalAgentType var1);

        public Builder pvp(boolean var1);

        public WorldCreationSettings build();
    }
}

