/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.extent;

import com.flowpowered.math.vector.Vector2i;
import org.spongepowered.api.util.DiscreteTransform2;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.extent.ImmutableBiomeArea;
import org.spongepowered.api.world.extent.MutableBiomeArea;
import org.spongepowered.api.world.extent.StorageType;
import org.spongepowered.api.world.extent.UnmodifiableBiomeArea;
import org.spongepowered.api.world.extent.worker.BiomeAreaWorker;

public interface BiomeArea {
    public Vector2i getBiomeMin();

    public Vector2i getBiomeMax();

    public Vector2i getBiomeSize();

    default public boolean containsBiome(Vector2i position) {
        return this.containsBiome(position.getX(), position.getY());
    }

    public boolean containsBiome(int var1, int var2);

    default public BiomeType getBiome(Vector2i position) {
        return this.getBiome(position.getX(), position.getY());
    }

    public BiomeType getBiome(int var1, int var2);

    public BiomeArea getBiomeView(Vector2i var1, Vector2i var2);

    public BiomeArea getBiomeView(DiscreteTransform2 var1);

    default public BiomeArea getRelativeBiomeView() {
        return this.getBiomeView(DiscreteTransform2.fromTranslation(this.getBiomeMin().negate()));
    }

    public UnmodifiableBiomeArea getUnmodifiableBiomeView();

    default public MutableBiomeArea getBiomeCopy() {
        return this.getBiomeCopy(StorageType.STANDARD);
    }

    public MutableBiomeArea getBiomeCopy(StorageType var1);

    public ImmutableBiomeArea getImmutableBiomeCopy();

    public BiomeAreaWorker<? extends BiomeArea> getBiomeWorker();
}

