/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.extent;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.ScheduledBlockUpdate;
import org.spongepowered.api.data.property.LocationBasePropertyHolder;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.DiscreteTransform3;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.EntityUniverse;
import org.spongepowered.api.world.extent.InteractableVolume;
import org.spongepowered.api.world.extent.LocationCompositeValueStore;
import org.spongepowered.api.world.extent.MutableBiomeArea;
import org.spongepowered.api.world.extent.TileEntityVolume;
import org.spongepowered.api.world.extent.worker.MutableBiomeAreaWorker;
import org.spongepowered.api.world.extent.worker.MutableBlockVolumeWorker;

public interface Extent
extends EntityUniverse,
TileEntityVolume,
InteractableVolume,
MutableBiomeArea,
LocationCompositeValueStore,
Identifiable,
LocationBasePropertyHolder {
    public Location<? extends Extent> getLocation(Vector3i var1);

    default public Location<? extends Extent> getLocation(int x, int y, int z) {
        return this.getLocation(new Vector3i(x, y, z));
    }

    public Location<? extends Extent> getLocation(Vector3d var1);

    default public Location<? extends Extent> getLocation(double x, double y, double z) {
        return this.getLocation(new Vector3i(x, y, z));
    }

    default public void setBlock(Vector3i position, BlockState block, boolean notifyNeighbors) {
        this.setBlock(position.getX(), position.getY(), position.getZ(), block, notifyNeighbors);
    }

    public void setBlock(int var1, int var2, int var3, BlockState var4, boolean var5);

    default public void setBlock(Vector3i position, BlockState blockState, boolean notifyNeighbors, Cause cause) {
        this.setBlock(position.getX(), position.getY(), position.getZ(), blockState, notifyNeighbors, cause);
    }

    public void setBlock(int var1, int var2, int var3, BlockState var4, boolean var5, Cause var6);

    default public void setBlockType(Vector3i position, BlockType type, boolean notifyNeighbors) {
        this.setBlockType(position.getX(), position.getY(), position.getZ(), type, notifyNeighbors);
    }

    default public void setBlockType(int x, int y, int z, BlockType type, boolean notifyNeighbors) {
        this.setBlock(x, y, z, type.getDefaultState(), notifyNeighbors);
    }

    default public void setBlockType(Vector3i position, BlockType type, boolean notifyNeighbors, Cause cause) {
        this.setBlock(position.getX(), position.getY(), position.getZ(), type.getDefaultState(), notifyNeighbors, cause);
    }

    default public void setBlockType(int x, int y, int z, BlockType type, boolean notifyNeighbors, Cause cause) {
        this.setBlock(x, y, z, type.getDefaultState(), notifyNeighbors, cause);
    }

    default public BlockSnapshot createSnapshot(Vector3i position) {
        return this.createSnapshot(position.getX(), position.getY(), position.getZ());
    }

    public BlockSnapshot createSnapshot(int var1, int var2, int var3);

    public boolean restoreSnapshot(BlockSnapshot var1, boolean var2, boolean var3);

    default public boolean restoreSnapshot(Vector3i position, BlockSnapshot snapshot, boolean force, boolean notifyNeighbors) {
        return this.restoreSnapshot(position.getX(), position.getY(), position.getZ(), snapshot, force, notifyNeighbors);
    }

    public boolean restoreSnapshot(int var1, int var2, int var3, BlockSnapshot var4, boolean var5, boolean var6);

    default public Collection<ScheduledBlockUpdate> getScheduledUpdates(Vector3i position) {
        return this.getScheduledUpdates(position.getX(), position.getY(), position.getZ());
    }

    public Collection<ScheduledBlockUpdate> getScheduledUpdates(int var1, int var2, int var3);

    default public ScheduledBlockUpdate addScheduledUpdate(Vector3i position, int priority, int ticks) {
        return this.addScheduledUpdate(position.getX(), position.getY(), position.getZ(), priority, ticks);
    }

    public ScheduledBlockUpdate addScheduledUpdate(int var1, int var2, int var3, int var4, int var5);

    default public void removeScheduledUpdate(Vector3i position, ScheduledBlockUpdate update) {
        this.removeScheduledUpdate(position.getX(), position.getY(), position.getZ(), update);
    }

    public void removeScheduledUpdate(int var1, int var2, int var3, ScheduledBlockUpdate var4);

    public boolean isLoaded();

    public Extent getExtentView(Vector3i var1, Vector3i var2);

    public Extent getExtentView(DiscreteTransform3 var1);

    default public Extent getRelativeExtentView() {
        return this.getExtentView(DiscreteTransform3.fromTranslation(this.getBlockMin().negate()));
    }

    @Override
    public MutableBiomeAreaWorker<? extends Extent> getBiomeWorker();

    @Override
    public MutableBlockVolumeWorker<? extends Extent> getBlockWorker();

    default public Optional<UUID> getCreator(Vector3i pos) {
        return this.getCreator(pos.getX(), pos.getY(), pos.getZ());
    }

    public Optional<UUID> getCreator(int var1, int var2, int var3);

    default public Optional<UUID> getNotifier(Vector3i pos) {
        return this.getNotifier(pos.getX(), pos.getY(), pos.getZ());
    }

    public Optional<UUID> getNotifier(int var1, int var2, int var3);

    default public void setCreator(Vector3i pos, @Nullable UUID uuid) {
        this.setCreator(pos.getX(), pos.getY(), pos.getZ(), uuid);
    }

    public void setCreator(int var1, int var2, int var3, @Nullable UUID var4);

    default public void setNotifier(Vector3i pos, @Nullable UUID uuid) {
        this.setNotifier(pos.getX(), pos.getY(), pos.getZ(), uuid);
    }

    public void setNotifier(int var1, int var2, int var3, @Nullable UUID var4);
}

