/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.gen.populator;

import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.manipulator.mutable.MobSpawnerData;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.util.weighted.LootTable;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.api.world.gen.Populator;

public interface Dungeon
extends Populator {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public VariableAmount getAttemptsPerChunk();

    public void setAttemptsPerChunk(VariableAmount var1);

    default public void setAttemptsPerChunk(int attempts) {
        this.setAttemptsPerChunk(VariableAmount.fixed(attempts));
    }

    public MobSpawnerData getSpawnerData();

    public LootTable<ItemStackSnapshot> getPossibleContents();

    public static interface Builder
    extends ResettableBuilder<Dungeon, Builder> {
        public Builder attempts(VariableAmount var1);

        default public Builder attempts(int attempts) {
            return this.attempts(VariableAmount.fixed(attempts));
        }

        public Builder mobSpawnerData(MobSpawnerData var1);

        public Builder minimumSpawnDelay(short var1);

        public Builder maximumSpawnDelay(short var1);

        public Builder spawnCount(short var1);

        public Builder maximumNearbyEntities(short var1);

        public Builder requiredPlayerRange(short var1);

        public Builder spawnRange(short var1);

        public Builder possibleEntities(WeightedTable<EntitySnapshot> var1);

        public Builder possibleItems(LootTable<ItemStackSnapshot> var1);

        public Dungeon build() throws IllegalStateException;
    }
}

