/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.gen.populator;

import com.google.common.base.Predicate;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.gen.Populator;

public interface RandomBlock
extends Populator {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public BlockState getBlock();

    public void setBlock(BlockState var1);

    public VariableAmount getAttemptsPerChunk();

    public void setAttemptsPerChunk(VariableAmount var1);

    default public void setAttemptsPerChunk(int count) {
        this.setAttemptsPerChunk(VariableAmount.fixed(count));
    }

    public VariableAmount getHeightRange();

    public void setHeightRange(VariableAmount var1);

    public Predicate<Location<World>> getPlacementTarget();

    public void getPlacementTarget(Predicate<Location<World>> var1);

    public static interface Builder
    extends ResettableBuilder<RandomBlock, Builder> {
        public Builder block(BlockState var1);

        public Builder perChunk(VariableAmount var1);

        default public Builder perChunk(int count) {
            return this.perChunk(VariableAmount.fixed(count));
        }

        public Builder placementTarget(Predicate<Location<World>> var1);

        public Builder height(VariableAmount var1);

        public RandomBlock build() throws IllegalStateException;
    }
}

