/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.gen.populator;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.type.ShrubType;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.gen.Populator;

public interface Shrub
extends Populator {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public WeightedTable<ShrubType> getTypes();

    public VariableAmount getShrubsPerChunk();

    public void setShrubsPerChunk(VariableAmount var1);

    default public void setShrubsPerChunk(int count) {
        this.setShrubsPerChunk(VariableAmount.fixed(count));
    }

    public Optional<Function<Location<Chunk>, ShrubType>> getSupplierOverride();

    public void setSupplierOverride(@Nullable Function<Location<Chunk>, ShrubType> var1);

    default public void clearSupplierOverride() {
        this.setSupplierOverride(null);
    }

    public static interface Builder
    extends ResettableBuilder<Shrub, Builder> {
        public Builder perChunk(VariableAmount var1);

        default public Builder perChunk(int count) {
            return this.perChunk(VariableAmount.fixed(count));
        }

        public Builder types(WeightedTable<ShrubType> var1);

        public Builder type(ShrubType var1, int var2);

        public Builder supplier(@Nullable Function<Location<Chunk>, ShrubType> var1);

        public Shrub build() throws IllegalStateException;
    }
}

