/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.storage;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.spongepowered.api.util.Direction;

public interface ChunkLayout {
    public Vector3i getChunkSize();

    public Vector3i getSpaceMax();

    public Vector3i getSpaceMin();

    public Vector3i getSpaceSize();

    public Vector3i getSpaceOrigin();

    default public boolean isValidChunk(Vector3i coords) {
        Preconditions.checkNotNull((Object)coords, (Object)"coords");
        return this.isValidChunk(coords.getX(), coords.getY(), coords.getZ());
    }

    default public boolean isValidChunk(int x, int y, int z) {
        return x >= this.getSpaceMin().getX() && x <= this.getSpaceMax().getX() && y >= this.getSpaceMin().getY() && y <= this.getSpaceMax().getY() && z >= this.getSpaceMin().getZ() && z <= this.getSpaceMax().getZ();
    }

    default public boolean isInChunk(Vector3i localCoords) {
        Preconditions.checkNotNull((Object)localCoords, (Object)"localCoords");
        return this.isInChunk(localCoords.getX(), localCoords.getY(), localCoords.getZ());
    }

    public boolean isInChunk(int var1, int var2, int var3);

    default public boolean isInChunk(Vector3i worldCoords, Vector3i chunkCoords) {
        Preconditions.checkNotNull((Object)worldCoords, (Object)"worldCoords");
        Preconditions.checkNotNull((Object)chunkCoords, (Object)"chunkCoords");
        return this.isInChunk(worldCoords.getX(), worldCoords.getY(), worldCoords.getZ(), chunkCoords.getX(), chunkCoords.getY(), chunkCoords.getZ());
    }

    public boolean isInChunk(int var1, int var2, int var3, int var4, int var5, int var6);

    default public Optional<Vector3i> toChunk(Vector3i worldCoords) {
        Preconditions.checkNotNull((Object)worldCoords, (Object)"worldCoords");
        return this.toChunk(worldCoords.getX(), worldCoords.getY(), worldCoords.getZ());
    }

    default public Optional<Vector3i> toChunk(int x, int y, int z) {
        Vector3i chunkCoords = this.forceToChunk(x, y, z);
        return this.isValidChunk(chunkCoords) ? Optional.of(chunkCoords) : Optional.empty();
    }

    default public Optional<Vector3i> toWorld(Vector3i chunkCoords) {
        Preconditions.checkNotNull((Object)chunkCoords, (Object)"chunkCoords");
        return this.toWorld(chunkCoords.getX(), chunkCoords.getY(), chunkCoords.getZ());
    }

    default public Optional<Vector3i> toWorld(int x, int y, int z) {
        return this.isValidChunk(x, y, z) ? Optional.of(this.forceToWorld(x, y, z)) : Optional.empty();
    }

    default public Vector3i forceToChunk(Vector3i worldCoords) {
        Preconditions.checkNotNull((Object)worldCoords, (Object)"worldCoords");
        return this.forceToChunk(worldCoords.getX(), worldCoords.getY(), worldCoords.getZ());
    }

    public Vector3i forceToChunk(int var1, int var2, int var3);

    default public Vector3i forceToWorld(Vector3i chunkCoords) {
        Preconditions.checkNotNull((Object)chunkCoords, (Object)"chunkCoords");
        return this.forceToWorld(chunkCoords.getX(), chunkCoords.getY(), chunkCoords.getZ());
    }

    public Vector3i forceToWorld(int var1, int var2, int var3);

    default public Optional<Vector3i> addToChunk(Vector3i chunkCoords, Vector3i chunkOffset) {
        Preconditions.checkNotNull((Object)chunkCoords, (Object)"chunkCoords");
        Preconditions.checkNotNull((Object)chunkOffset, (Object)"chunkOffset");
        return this.addToChunk(chunkCoords.getX(), chunkCoords.getY(), chunkCoords.getZ(), chunkOffset.getX(), chunkOffset.getY(), chunkOffset.getZ());
    }

    default public Optional<Vector3i> addToChunk(int cx, int cy, int cz, int ox, int oy, int oz) {
        Vector3i newChunkCoords = new Vector3i(cx + ox, cy + oy, cz + oz);
        return this.isValidChunk(newChunkCoords) ? Optional.of(newChunkCoords) : Optional.empty();
    }

    default public Optional<Vector3i> moveToChunk(Vector3i chunkCoords, Direction direction) {
        return this.moveToChunk(chunkCoords, direction, 1);
    }

    default public Optional<Vector3i> moveToChunk(int x, int y, int z, Direction direction) {
        return this.moveToChunk(new Vector3i(x, y, z), direction);
    }

    default public Optional<Vector3i> moveToChunk(Vector3i chunkCoords, Direction direction, int steps) {
        Preconditions.checkNotNull((Object)((Object)direction), (Object)"direction");
        Preconditions.checkArgument((!direction.isSecondaryOrdinal() ? 1 : 0) != 0, (Object)"Secondary cardinal directions can't be used here");
        return this.addToChunk(chunkCoords, direction.toVector3d().ceil().toInt().mul(steps));
    }

    default public Optional<Vector3i> moveToChunk(int x, int y, int z, Direction direction, int steps) {
        return this.moveToChunk(new Vector3i(x, y, z), direction, steps);
    }
}

