/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;

public final class DataQuery {
    private static final DataQuery EMPTY = new DataQuery(new String[0]);
    private final ImmutableList<String> parts;
    private ImmutableList<DataQuery> queryParts;

    private DataQuery(char separator, String path) {
        this(path.split(Pattern.quote(String.valueOf(separator))));
    }

    private DataQuery(String ... parts) {
        this.parts = ImmutableList.copyOf((Object[])parts);
    }

    private DataQuery(List<String> parts) {
        this.parts = ImmutableList.copyOf(parts);
    }

    public static DataQuery of() {
        return EMPTY;
    }

    public static DataQuery of(char separator, String path) {
        return new DataQuery(separator, path);
    }

    public static DataQuery of(String ... parts) {
        if (parts.length == 0) {
            return EMPTY;
        }
        return new DataQuery(parts);
    }

    public static DataQuery of(List<String> parts) {
        if (parts.isEmpty()) {
            return EMPTY;
        }
        return new DataQuery(parts);
    }

    public List<String> getParts() {
        return this.parts;
    }

    public DataQuery then(DataQuery that) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll(this.parts);
        builder.addAll(that.parts);
        return new DataQuery((List<String>)builder.build());
    }

    public DataQuery then(String that) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll(this.parts);
        builder.add((Object)that);
        return new DataQuery((List<String>)builder.build());
    }

    public List<DataQuery> getQueryParts() {
        if (this.queryParts == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String part : this.getParts()) {
                builder.add((Object)new DataQuery(part));
            }
            this.queryParts = builder.build();
        }
        return this.queryParts;
    }

    public DataQuery pop() {
        if (this.parts.size() <= 1) {
            return DataQuery.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < this.parts.size() - 1; ++i) {
            builder.add(this.parts.get(i));
        }
        return new DataQuery((List<String>)builder.build());
    }

    public DataQuery popFirst() {
        if (this.parts.size() <= 1) {
            return DataQuery.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 1; i < this.parts.size(); ++i) {
            builder.add(this.parts.get(i));
        }
        return new DataQuery((List<String>)builder.build());
    }

    public DataQuery last() {
        if (this.parts.size() <= 1) {
            return this;
        }
        return new DataQuery((String)this.parts.get(this.parts.size() - 1));
    }

    public String asString(String separator) {
        return Joiner.on((String)separator).join(this.parts);
    }

    public String asString(char separator) {
        return this.asString(String.valueOf(separator));
    }

    public String toString() {
        return this.asString('.');
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.parts});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DataQuery other = (DataQuery)obj;
        return Objects.equal(this.parts, other.parts);
    }
}

