/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.manipulator;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Function;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.util.annotation.TransformWith;

public interface DataManipulator<M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>>
extends DataSerializable,
ValueContainer<M> {
    default public Optional<M> fill(DataHolder dataHolder) {
        return this.fill(dataHolder, MergeFunction.IGNORE_ALL);
    }

    public Optional<M> fill(DataHolder var1, MergeFunction var2);

    public Optional<M> from(DataContainer var1);

    public <E> M set(Key<? extends BaseValue<E>> var1, E var2);

    default public M set(BaseValue<?> value) {
        return this.set(value.getKey(), value.get());
    }

    default public M set(BaseValue<?> ... values) {
        for (BaseValue value : (BaseValue[])Preconditions.checkNotNull(values)) {
            try {
                this.set((BaseValue<?>)((BaseValue)Preconditions.checkNotNull((Object)value, (Object)"A null value was provided!")));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return (M)this;
    }

    default public M set(Iterable<? extends BaseValue<?>> values) {
        for (BaseValue value : (Iterable)Preconditions.checkNotNull(values)) {
            try {
                this.set((BaseValue<?>)((BaseValue)Preconditions.checkNotNull((Object)value, (Object)"A null value was provided!")));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return (M)this;
    }

    default public <E> M transform(Key<? extends BaseValue<E>> key, Function<E, E> function) {
        Preconditions.checkArgument((boolean)this.supports(key), (Object)("The provided key is not supported!" + key.toString()));
        return this.set(key, Preconditions.checkNotNull(function.apply(this.get(key).get()), (Object)"The function can not be returning null!"));
    }

    @Override
    @TransformWith
    public M copy();

    public I asImmutable();
}

