/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.api.Game;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.game.state.GameStateEvent;
import org.spongepowered.api.eventgencore.classwrapper.reflection.ReflectionUtils;
import org.spongepowered.api.util.generator.event.factory.ClassGeneratorProvider;
import org.spongepowered.api.util.generator.event.factory.EventFactory;
import org.spongepowered.api.util.generator.event.factory.NullPolicy;
import org.spongepowered.api.util.generator.event.factory.plugin.AccessorModifierEventFactoryPlugin;
import org.spongepowered.api.util.generator.event.factory.plugin.EventFactoryPlugin;

public class SpongeEventFactoryUtils {
    static final ClassGeneratorProvider factoryProvider = new ClassGeneratorProvider("org.spongepowered.api.event.impl");
    public static List<? extends EventFactoryPlugin> plugins = Lists.newArrayList((Object[])new AccessorModifierEventFactoryPlugin[]{new AccessorModifierEventFactoryPlugin()});
    private static final LoadingCache<Class<?>, EventFactory<?>> factories = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, EventFactory<?>>(){

        public EventFactory<?> load(Class<?> type) {
            return factoryProvider.create(type, ReflectionUtils.getBaseClass(type).getActualClass(), plugins);
        }
    });

    public static <T> T createEventImpl(Class<T> type, Map<String, Object> values) {
        return (T)((EventFactory)factories.getUnchecked(type)).apply(values);
    }

    public static <T extends GameStateEvent> T createState(Class<T> type, Game game) {
        HashMap values = Maps.newHashMapWithExpectedSize((int)2);
        values.put("state", game.getState());
        values.put("cause", Cause.source(game).build());
        return (T)((GameStateEvent)SpongeEventFactoryUtils.createEventImpl(type, values));
    }

    static {
        factoryProvider.setNullPolicy(NullPolicy.NON_NULL_BY_DEFAULT);
    }
}

