/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.world.TargetWorldEvent;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public interface ChangeBlockEvent
extends TargetWorldEvent,
Cancellable {
    public List<Transaction<BlockSnapshot>> getTransactions();

    default public List<Transaction<BlockSnapshot>> filter(Predicate<Location<World>> predicate) {
        ArrayList invalidatedTransactions = Lists.newArrayList();
        for (Transaction<BlockSnapshot> transaction : this.getTransactions()) {
            if (predicate.test(transaction.getOriginal().getLocation().get())) continue;
            transaction.setValid(false);
            invalidatedTransactions.add(transaction);
        }
        return invalidatedTransactions;
    }

    default public void filterAll() {
        for (Transaction<BlockSnapshot> transaction : this.getTransactions()) {
            transaction.setValid(false);
        }
    }

    public static interface Post
    extends ChangeBlockEvent {
    }

    public static interface Modify
    extends ChangeBlockEvent {
    }

    public static interface Place
    extends ChangeBlockEvent {
    }

    public static interface Break
    extends ChangeBlockEvent {
    }

    public static interface Grow
    extends ChangeBlockEvent {
    }

    public static interface Decay
    extends ChangeBlockEvent {
    }

    public static interface Pre
    extends TargetWorldEvent,
    Cancellable {
        public List<Location<World>> getLocations();
    }
}

