/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.cause;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.util.ResettableBuilder;

public final class Cause {
    final Object[] cause;
    final String[] names;
    @Nullable
    private Map<String, Object> namedObjectMap;
    @Nullable
    private ImmutableList<Object> immutableCauses;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder source(Object root) {
        return new Builder().source(root);
    }

    public static Cause of(NamedCause cause) {
        Preconditions.checkNotNull((Object)cause, (Object)"Cause cannot be null!");
        return new Cause(new NamedCause[]{cause});
    }

    public static Cause of(NamedCause cause, NamedCause ... causes) {
        Builder builder = Cause.builder();
        builder.named(cause);
        for (NamedCause namedCause : causes) {
            builder.named(namedCause);
        }
        return builder.build();
    }

    public static Cause of(Iterable<NamedCause> iterable) {
        Builder builder = Cause.builder();
        for (NamedCause cause : iterable) {
            builder.named(cause);
        }
        return builder.build();
    }

    Cause(NamedCause[] causes) {
        Object[] objects = new Object[causes.length];
        String[] names = new String[causes.length];
        for (int index = 0; index < causes.length; ++index) {
            NamedCause aCause = causes[index];
            Preconditions.checkNotNull((Object)aCause, (Object)"Null cause element!");
            objects[index] = aCause.getCauseObject();
            names[index] = aCause.getName();
        }
        this.cause = objects;
        this.names = names;
    }

    public Object root() {
        return this.cause[0];
    }

    public <T> Optional<T> first(Class<T> target) {
        for (Object aCause : this.cause) {
            if (!target.isInstance(aCause)) continue;
            return Optional.of(aCause);
        }
        return Optional.empty();
    }

    public <T> Optional<T> last(Class<T> target) {
        for (int i = this.cause.length - 1; i >= 0; --i) {
            if (!target.isInstance(this.cause[i])) continue;
            return Optional.of(this.cause[i]);
        }
        return Optional.empty();
    }

    public <T> Optional<T> get(String named, Class<T> expected) {
        Preconditions.checkArgument((named != null ? 1 : 0) != 0, (Object)"The name cannot be null!");
        Preconditions.checkArgument((expected != null ? 1 : 0) != 0, (Object)"The expected class cannot be null!");
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equalsIgnoreCase(named)) continue;
            Object object = this.cause[i];
            if (expected.isInstance(object)) {
                return Optional.of(object);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public Optional<?> before(Class<?> clazz) {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"The provided class cannot be null!");
        if (this.cause.length == 1) {
            return Optional.empty();
        }
        for (int i = 0; i < this.cause.length; ++i) {
            if (!clazz.isInstance(this.cause[i]) || i <= 0) continue;
            return Optional.of(this.cause[i - 1]);
        }
        return Optional.empty();
    }

    public Optional<?> before(String named) {
        Preconditions.checkArgument((named != null ? 1 : 0) != 0, (Object)"The name cannot be null!");
        if (this.cause.length == 1) {
            return Optional.empty();
        }
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equalsIgnoreCase(named)) continue;
            try {
                Object object = this.cause[i - 1];
                return Optional.of(object);
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public Optional<?> after(Class<?> clazz) {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"The provided class cannot be null!");
        if (this.cause.length == 1) {
            return Optional.empty();
        }
        for (int i = 0; i < this.cause.length; ++i) {
            if (!clazz.isInstance(this.cause[i]) || i + 1 >= this.cause.length) continue;
            return Optional.of(this.cause[i + 1]);
        }
        return Optional.empty();
    }

    public Optional<?> after(String named) {
        Preconditions.checkArgument((named != null ? 1 : 0) != 0, (Object)"The name cannot be null!");
        if (this.cause.length == 1) {
            return Optional.empty();
        }
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equalsIgnoreCase(named) || i + 1 >= this.cause.length) continue;
            try {
                Object object = this.cause[i + 1];
                return Optional.of(object);
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public boolean containsType(Class<?> target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"The provided class cannot be null!");
        for (Object aCause : this.cause) {
            if (!target.isInstance(aCause)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Object object) {
        for (Object aCause : this.cause) {
            if (!aCause.equals(object)) continue;
            return true;
        }
        return false;
    }

    public boolean containsNamed(String named) {
        Preconditions.checkArgument((named != null ? 1 : 0) != 0, (Object)"The name cannot be null!");
        for (String name : this.names) {
            if (!name.equalsIgnoreCase(named)) continue;
            return true;
        }
        return false;
    }

    public <T> List<T> allOf(Class<T> target) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object aCause : this.cause) {
            if (!target.isInstance(aCause)) continue;
            builder.add(aCause);
        }
        return builder.build();
    }

    public List<Object> noneOf(Class<?> ignoredClass) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object cause : this.cause) {
            if (ignoredClass.isInstance(cause)) continue;
            builder.add(cause);
        }
        return builder.build();
    }

    public List<Object> all() {
        if (this.immutableCauses == null) {
            this.immutableCauses = ImmutableList.copyOf((Object[])this.cause);
        }
        return this.immutableCauses;
    }

    public Cause with(NamedCause additional, NamedCause ... additionals) {
        Preconditions.checkArgument((additional != null ? 1 : 0) != 0, (Object)"No null arguments allowed!");
        ArrayList<NamedCause> list = new ArrayList<NamedCause>();
        list.add(additional);
        for (NamedCause object : additionals) {
            Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)"Cannot add null objects!");
            list.add(object);
        }
        return this.with(list);
    }

    public Cause with(Iterable<NamedCause> iterable) {
        Builder builder = new Builder().from(this);
        for (NamedCause o : iterable) {
            Preconditions.checkArgument((o != null ? 1 : 0) != 0, (Object)"Cannot add null causes");
            builder.named(o);
        }
        return builder.build();
    }

    public Cause merge(Cause cause) {
        Builder builder = Cause.builder().from(this);
        for (int i = 0; i < cause.cause.length; ++i) {
            builder.suggestNamed(cause.names[i], cause.cause[i]);
        }
        return builder.build();
    }

    public Map<String, Object> getNamedCauses() {
        if (this.namedObjectMap == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < this.names.length; ++i) {
                builder.put((Object)this.names[i], this.cause[i]);
            }
            this.namedObjectMap = builder.build();
        }
        return this.namedObjectMap;
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof Cause) {
            Cause cause = (Cause)object;
            return Arrays.equals(this.cause, cause.cause);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])this.cause);
    }

    public String toString() {
        String causeString = "Cause[";
        StringJoiner joiner = new StringJoiner(", ");
        for (int i = 0; i < this.cause.length; ++i) {
            joiner.add("{Name=" + this.names[i] + ", Object={" + this.cause[i].toString() + "}}");
        }
        return causeString + joiner.toString() + "]";
    }

    public static final class Builder
    implements ResettableBuilder<Cause, Builder> {
        List<NamedCause> causes = new ArrayList<NamedCause>();
        Set<String> namesUsed = new HashSet<String>();

        Builder() {
        }

        Builder source(Object object) {
            this.causes.add(NamedCause.source(Preconditions.checkNotNull((Object)object, (Object)"Source cannot be null!")));
            this.namesUsed.add("Source");
            return this;
        }

        public Builder owner(Object object) {
            Preconditions.checkArgument((!this.namesUsed.contains("Owner") ? 1 : 0) != 0, (Object)"Already contains an owner!");
            this.causes.add(NamedCause.owner(object));
            this.namesUsed.add("Owner");
            return this;
        }

        public Builder notifier(Object object) {
            Preconditions.checkArgument((!this.namesUsed.contains("Notifier") ? 1 : 0) != 0, (Object)"Already contains a notifier!");
            this.causes.add(NamedCause.notifier(object));
            this.namesUsed.add("Notifier");
            return this;
        }

        public Builder named(NamedCause cause) {
            Preconditions.checkNotNull((Object)cause, (Object)"NamedCause cannot be null!");
            Preconditions.checkArgument((!this.namesUsed.contains(cause.getName()) ? 1 : 0) != 0, (String)"Already contains an entry for: {}", (Object[])new Object[]{cause.getName()});
            this.causes.add(cause);
            this.namesUsed.add(cause.getName());
            return this;
        }

        public Builder named(String name, Object object) {
            Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null!");
            Preconditions.checkArgument((!this.namesUsed.contains(name) ? 1 : 0) != 0, (String)"Already contains an entry for {}", (Object[])new Object[]{name});
            this.causes.add(NamedCause.of(name, object));
            this.namesUsed.add(name);
            return this;
        }

        public Builder suggestNamed(String name, Object object) {
            Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null!");
            Preconditions.checkNotNull((Object)object, (Object)"Object cannot be null!");
            int iteration = 1;
            if (this.namesUsed.contains(name)) {
                String newName;
                while (this.namesUsed.contains(newName = name + iteration++)) {
                }
                this.causes.add(NamedCause.of(newName, object));
                this.namesUsed.add(newName);
            } else {
                this.causes.add(NamedCause.of(name, object));
                this.namesUsed.add(name);
            }
            return this;
        }

        public Builder addAll(Collection<NamedCause> causes) {
            Preconditions.checkNotNull(causes, (Object)"Causes cannot be null!");
            causes.forEach(this::named);
            return this;
        }

        public Cause build() {
            Preconditions.checkState((!this.causes.isEmpty() ? 1 : 0) != 0, (Object)"Cannot create an empty Cause!");
            return new Cause(this.causes.toArray(new NamedCause[this.causes.size()]));
        }

        @Override
        public Builder from(Cause value) {
            for (int i = 0; i < value.cause.length; ++i) {
                this.causes.add(NamedCause.of(value.names[i], value.cause[i]));
                this.namesUsed.add(value.names[i]);
            }
            return this;
        }

        @Override
        public Builder reset() {
            this.causes.clear();
            this.namesUsed.clear();
            return this;
        }
    }
}

