/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.extra.modifier.skylands;

import com.flowpowered.math.GenericMath;
import com.flowpowered.math.vector.Vector3i;
import com.flowpowered.noise.module.Module;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.world.extent.MutableBlockVolume;

class SkylandsUtil {
    SkylandsUtil() {
    }

    static double[] fastNoise(Module noiseGenerator, Vector3i samplingRate, int x, int y, int z, int xSize, int ySize, int zSize) {
        int zz;
        int samplingRateX = samplingRate.getX();
        int samplingRateY = samplingRate.getY();
        int samplingRateZ = samplingRate.getZ();
        double[] noiseArray = new double[++xSize * ++ySize * ++zSize];
        for (zz = 0; zz < zSize; zz += samplingRateZ) {
            for (int yy = 0; yy < ySize; yy += samplingRateY) {
                for (int xx = 0; xx < xSize; xx += samplingRateX) {
                    noiseArray[SkylandsUtil.index3D((int)xx, (int)yy, (int)zz, (int)xSize, (int)ySize)] = noiseGenerator.getValue((double)(x + xx), (double)(y + yy), (double)(z + zz));
                }
            }
        }
        for (zz = 0; zz < zSize - 1; ++zz) {
            int zFract = zz % samplingRateZ;
            int zPrevious = zz - zFract;
            int zNext = zPrevious + samplingRateZ;
            for (int yy = 0; yy < ySize - 1; ++yy) {
                int yFract = yy % samplingRateY;
                int yPrevious = yy - yFract;
                int yNext = yPrevious + samplingRateY;
                for (int xx = 0; xx < xSize - 1; ++xx) {
                    int xFract = xx % samplingRateX;
                    if (xFract == 0 && yFract == 0 && zFract == 0) continue;
                    int xPrevious = xx - xFract;
                    int xNext = xPrevious + samplingRateX;
                    noiseArray[SkylandsUtil.index3D((int)xx, (int)yy, (int)zz, (int)xSize, (int)ySize)] = GenericMath.triLerp((double)xx, (double)yy, (double)zz, (double)noiseArray[SkylandsUtil.index3D(xPrevious, yPrevious, zPrevious, xSize, ySize)], (double)noiseArray[SkylandsUtil.index3D(xPrevious, yNext, zPrevious, xSize, ySize)], (double)noiseArray[SkylandsUtil.index3D(xPrevious, yPrevious, zNext, xSize, ySize)], (double)noiseArray[SkylandsUtil.index3D(xPrevious, yNext, zNext, xSize, ySize)], (double)noiseArray[SkylandsUtil.index3D(xNext, yPrevious, zPrevious, xSize, ySize)], (double)noiseArray[SkylandsUtil.index3D(xNext, yNext, zPrevious, xSize, ySize)], (double)noiseArray[SkylandsUtil.index3D(xNext, yPrevious, zNext, xSize, ySize)], (double)noiseArray[SkylandsUtil.index3D(xNext, yNext, zNext, xSize, ySize)], (double)xPrevious, (double)xNext, (double)yPrevious, (double)yNext, (double)zPrevious, (double)zNext);
                }
            }
        }
        return noiseArray;
    }

    static int index3D(int x, int y, int z, int xSize, int ySize) {
        return z * xSize * ySize + y * xSize + x;
    }

    static float hashToFloat(int x, int y, long seed) {
        long hash = (long)(x * 73428767 ^ y * 9122569) ^ seed * 457L;
        return (float)(hash * (hash + 456149L) & 0xFFFFFFL) / 1.6777216E7f;
    }

    static float hashToFloat(int x, int y, int z, long seed) {
        long hash = (long)(x * 73428767 ^ y * 9122569 ^ z * 4382893) ^ seed * 457L;
        return (float)(hash * (hash + 456149L) & 0xFFFFFFL) / 1.6777216E7f;
    }

    static int getNextSolid(MutableBlockVolume buffer, int x, int y, int z, int yEnd) {
        while (y >= yEnd && buffer.getBlockType(x, y, z).equals(BlockTypes.AIR)) {
            --y;
        }
        return y;
    }

    static int getNextAir(MutableBlockVolume buffer, int x, int y, int z, int yEnd) {
        while (y >= yEnd && !buffer.getBlockType(x, y, z).equals(BlockTypes.AIR)) {
            --y;
        }
        return y;
    }
}

