/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.inventory;

import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.text.translation.Translatable;

public interface ItemStack
extends DataHolder,
Translatable {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public static ItemStack of(ItemType itemType, int quantity) {
        return ItemStack.builder().itemType(itemType).quantity(quantity).build();
    }

    public ItemType getItem();

    public int getQuantity();

    public void setQuantity(int var1) throws IllegalArgumentException;

    public int getMaxStackQuantity();

    public ItemStackSnapshot createSnapshot();

    public boolean equalTo(ItemStack var1);

    @Override
    public ItemStack copy();

    public static interface Builder
    extends DataBuilder<ItemStack> {
        @Override
        public Builder from(ItemStack var1);

        public Builder itemType(ItemType var1);

        public ItemType getCurrentItem();

        public Builder quantity(int var1) throws IllegalArgumentException;

        public <E> Builder keyValue(Key<? extends BaseValue<E>> var1, E var2);

        public Builder itemData(DataManipulator<?, ?> var1) throws IllegalArgumentException;

        public Builder itemData(ImmutableDataManipulator<?, ?> var1) throws IllegalArgumentException;

        public <V> Builder add(Key<? extends BaseValue<V>> var1, V var2) throws IllegalArgumentException;

        public Builder fromItemStack(ItemStack var1);

        default public Builder fromBlockState(BlockState blockState) {
            Preconditions.checkNotNull((Object)blockState);
            BlockType blockType = blockState.getType();
            Preconditions.checkArgument((boolean)blockType.getItem().isPresent(), (Object)("Missing valid ItemType for BlockType: " + blockType.getId()));
            this.itemType(blockType.getItem().get());
            blockState.getContainers().forEach(this::itemData);
            return this;
        }

        public Builder fromContainer(DataView var1);

        default public Builder fromSnapshot(ItemStackSnapshot snapshot) {
            return this.fromItemStack(snapshot.createStack());
        }

        public Builder fromBlockSnapshot(BlockSnapshot var1);

        public Builder remove(Class<? extends DataManipulator<?, ?>> var1);

        default public Builder apply(Predicate<Builder> predicate, Consumer<Builder> consumer) {
            if (predicate.test(this)) {
                consumer.accept(this);
            }
            return this;
        }

        public ItemStack build() throws IllegalStateException;
    }
}

