/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.inventory.property;

import com.flowpowered.math.vector.Vector2i;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.item.inventory.property.AbstractInventoryProperty;
import org.spongepowered.api.util.Coerce;

public class InventoryDimension
extends AbstractInventoryProperty<String, Vector2i> {
    public static final String PROPERTY_NAM = "inventorydimension";

    public InventoryDimension(Vector2i value) {
        super(value);
    }

    public InventoryDimension(int width, int height) {
        super(new Vector2i(width, height));
    }

    public InventoryDimension(Vector2i value, Property.Operator operator) {
        super(value, operator);
    }

    public InventoryDimension(int width, int height, Property.Operator operator) {
        super(new Vector2i(width, height), operator);
    }

    public InventoryDimension(Object value, Property.Operator operator) {
        super(Coerce.toVector2i(value), operator);
    }

    public int getColumns() {
        return ((Vector2i)this.getValue()).getX();
    }

    public int getRows() {
        return ((Vector2i)this.getValue()).getY();
    }

    @Override
    public int compareTo(Property<?, ?> other) {
        if (other == null) {
            return 1;
        }
        return ((Vector2i)this.getValue()).compareTo(Coerce.toVector2i(other.getValue()));
    }

    public static InventoryDimension of(Object value) {
        return new InventoryDimension(value, Property.Operator.EQUAL);
    }

    public static InventoryDimension of(int width, int height) {
        return new InventoryDimension(new Vector2i(width, height), Property.Operator.EQUAL);
    }

    public static InventoryDimension not(Object value) {
        return new InventoryDimension(value, Property.Operator.NOTEQUAL);
    }

    public static InventoryDimension greaterThan(Object value) {
        return new InventoryDimension(value, Property.Operator.GREATER);
    }

    public static InventoryDimension greaterThanOrEqual(Object value) {
        return new InventoryDimension(value, Property.Operator.GEQUAL);
    }

    public static InventoryDimension lessThan(Object value) {
        return new InventoryDimension(value, Property.Operator.LESS);
    }

    public static InventoryDimension lessThanOrEqual(Object value) {
        return new InventoryDimension(value, Property.Operator.LEQUAL);
    }
}

