/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.inventory.transaction;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.ResettableBuilder;

public final class InventoryTransactionResult {
    final Type type;
    private final List<ItemStackSnapshot> rejected;
    private final List<ItemStackSnapshot> replaced;

    public static Builder builder() {
        return new Builder();
    }

    public static InventoryTransactionResult successNoTransactions() {
        return InventoryTransactionResult.builder().type(Type.SUCCESS).build();
    }

    public static InventoryTransactionResult failNoTransactions() {
        return InventoryTransactionResult.builder().type(Type.ERROR).build();
    }

    InventoryTransactionResult(Builder builder) {
        this.type = builder.resultType;
        this.rejected = builder.rejected != null ? ImmutableList.copyOf(builder.rejected) : Collections.emptyList();
        this.replaced = builder.replaced != null ? ImmutableList.copyOf(builder.replaced) : Collections.emptyList();
    }

    public Type getType() {
        return this.type;
    }

    public Collection<ItemStackSnapshot> getRejectedItems() {
        return this.rejected;
    }

    public Collection<ItemStackSnapshot> getReplacedItems() {
        return this.replaced;
    }

    public static final class Builder
    implements ResettableBuilder<InventoryTransactionResult, Builder> {
        Type resultType;
        List<ItemStackSnapshot> rejected;
        List<ItemStackSnapshot> replaced;

        Builder() {
        }

        public Builder type(Type type) {
            this.resultType = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"Type cannot be null!"));
            return this;
        }

        public Builder reject(ItemStack ... itemStacks) {
            if (this.rejected == null) {
                this.rejected = new ArrayList<ItemStackSnapshot>();
            }
            for (ItemStack itemStack1 : itemStacks) {
                if (itemStack1 == null) continue;
                this.rejected.add(itemStack1.createSnapshot());
            }
            return this;
        }

        public Builder replace(ItemStack ... itemStacks) {
            if (this.replaced == null) {
                this.replaced = new ArrayList<ItemStackSnapshot>();
            }
            for (ItemStack itemStack1 : itemStacks) {
                if (itemStack1 == null) continue;
                this.replaced.add(itemStack1.createSnapshot());
            }
            return this;
        }

        public InventoryTransactionResult build() {
            Preconditions.checkState((this.resultType != null ? 1 : 0) != 0, (Object)"ResultType cannot be null!");
            return new InventoryTransactionResult(this);
        }

        @Override
        public Builder from(InventoryTransactionResult value) {
            Preconditions.checkNotNull((Object)value, (Object)"InventoryTransactionResult cannot be null!");
            this.resultType = (Type)((Object)Preconditions.checkNotNull((Object)((Object)value.type), (Object)"ResultType cannot be null!"));
            this.replaced = new ArrayList<ItemStackSnapshot>(value.getReplacedItems());
            this.rejected = new ArrayList<ItemStackSnapshot>(value.getRejectedItems());
            return this;
        }

        @Override
        public Builder reset() {
            this.resultType = null;
            this.rejected = null;
            this.replaced = null;
            return this;
        }
    }

    public static enum Type {
        UNDEFINED,
        SUCCESS,
        FAILURE,
        ERROR,
        CANCELLED;

    }
}

