/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.plugin;

import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;

public interface PluginContainer {
    public String getId();

    default public String getName() {
        return this.getId();
    }

    default public Optional<String> getVersion() {
        return Optional.empty();
    }

    default public Optional<String> getDescription() {
        return Optional.empty();
    }

    default public Optional<String> getUrl() {
        return Optional.empty();
    }

    default public Optional<String> getMinecraftVersion() {
        return Optional.empty();
    }

    default public List<String> getAuthors() {
        return ImmutableList.of();
    }

    default public Optional<Asset> getAsset(String name) {
        return Sponge.getAssetManager().getAsset(this, name);
    }

    default public Optional<Path> getSource() {
        return Optional.empty();
    }

    default public Optional<?> getInstance() {
        return Optional.empty();
    }

    default public Logger getLogger() {
        return LoggerFactory.getLogger((String)this.getId());
    }
}

