/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text.transform;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.spongepowered.api.text.transform.PartitionedTextFormatter;
import org.spongepowered.api.text.transform.SimpleTextFormatter;

public class FixedPartitionedTextFormatter
implements PartitionedTextFormatter<SimpleTextFormatter> {
    final SimpleTextFormatter[] partitions;

    public FixedPartitionedTextFormatter(int size) {
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (Object)"size must be greater than or equal to zero");
        this.partitions = new SimpleTextFormatter[size];
        for (int i = 0; i < size; ++i) {
            this.partitions[i] = new SimpleTextFormatter();
        }
    }

    public FixedPartitionedTextFormatter() {
        this(2);
    }

    @Override
    public ImmutableList<SimpleTextFormatter> getAll() {
        return ImmutableList.copyOf((Object[])this.partitions);
    }

    @Override
    public SimpleTextFormatter get(int i) {
        return this.partitions[i];
    }

    @Override
    public SimpleTextFormatter set(int i, SimpleTextFormatter element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.partitions.length;
    }

    @Override
    public boolean isEmpty() {
        boolean empty = true;
        for (SimpleTextFormatter partition : this) {
            empty &= partition.isEmpty();
        }
        return empty;
    }

    @Override
    public boolean contains(SimpleTextFormatter element) {
        for (SimpleTextFormatter partition : this) {
            if (!partition.equals(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.forEach(SimpleTextFormatter::clear);
    }

    @Override
    public boolean add(SimpleTextFormatter element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(Collection<SimpleTextFormatter> elements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insert(int i, SimpleTextFormatter element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insert(int i, Collection<SimpleTextFormatter> elements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(SimpleTextFormatter element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Collection<SimpleTextFormatter> elements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retain(Collection<SimpleTextFormatter> elements) {
        throw new UnsupportedOperationException();
    }
}

