/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text.transform;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.spongepowered.api.text.transform.SimpleTextTemplateApplier;
import org.spongepowered.api.text.transform.TextFormatter;

public class SimpleTextFormatter
implements TextFormatter<SimpleTextTemplateApplier> {
    protected final List<SimpleTextTemplateApplier> parts;

    public SimpleTextFormatter(int initialSize) {
        Preconditions.checkArgument((initialSize >= 0 ? 1 : 0) != 0, (Object)"initial size must be greater than or equal to zero");
        this.parts = new ArrayList<SimpleTextTemplateApplier>(initialSize);
        for (int i = 0; i < initialSize; ++i) {
            this.parts.add(new SimpleTextTemplateApplier());
        }
    }

    public SimpleTextFormatter() {
        this(0);
    }

    @Override
    public ImmutableList<SimpleTextTemplateApplier> getAll() {
        return ImmutableList.copyOf(this.parts);
    }

    @Override
    public SimpleTextTemplateApplier get(int i) {
        return this.parts.get(i);
    }

    @Override
    public SimpleTextTemplateApplier set(int i, SimpleTextTemplateApplier element) {
        return this.parts.set(i, element);
    }

    @Override
    public int size() {
        return this.parts.size();
    }

    @Override
    public boolean isEmpty() {
        return this.parts.isEmpty();
    }

    @Override
    public boolean contains(SimpleTextTemplateApplier element) {
        return this.parts.contains(element);
    }

    @Override
    public void clear() {
        this.parts.clear();
    }

    @Override
    public boolean add(SimpleTextTemplateApplier element) {
        return this.parts.add(element);
    }

    @Override
    public boolean add(Collection<SimpleTextTemplateApplier> elements) {
        return this.parts.addAll(elements);
    }

    @Override
    public void insert(int i, SimpleTextTemplateApplier element) {
        this.parts.add(i, element);
    }

    @Override
    public void insert(int i, Collection<SimpleTextTemplateApplier> elements) {
        this.parts.addAll(i, elements);
    }

    @Override
    public boolean remove(SimpleTextTemplateApplier element) {
        return this.parts.remove(element);
    }

    @Override
    public boolean remove(Collection<SimpleTextTemplateApplier> elements) {
        return this.parts.removeAll(elements);
    }

    @Override
    public boolean retain(Collection<SimpleTextTemplateApplier> elements) {
        return this.parts.retainAll(elements);
    }
}

