/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util;

import com.flowpowered.math.GenericMath;
import com.flowpowered.math.imaginary.Quaterniond;
import com.flowpowered.math.matrix.Matrix3d;
import com.flowpowered.math.matrix.Matrix4d;
import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.flowpowered.math.vector.Vector4d;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Optional;
import org.spongepowered.api.util.Axis;
import org.spongepowered.api.util.DiscreteTransform2;

public class DiscreteTransform3 {
    public static final DiscreteTransform3 IDENTITY = new DiscreteTransform3(Matrix4d.IDENTITY);
    private final Matrix4d matrix;
    private final Vector4d matrixRow0;
    private final Vector4d matrixRow1;
    private final Vector4d matrixRow2;

    private DiscreteTransform3(Matrix4d matrix) {
        this.matrix = matrix;
        this.matrixRow0 = matrix.getRow(0);
        this.matrixRow1 = matrix.getRow(1);
        this.matrixRow2 = matrix.getRow(2);
    }

    public Matrix4d getMatrix() {
        return this.matrix;
    }

    public Vector3i transform(Vector3i vector) {
        return this.transform(vector.getX(), vector.getY(), vector.getZ());
    }

    public Vector3i transform(int x, int y, int z) {
        return new Vector3i(this.transformX(x, y, z), this.transformY(x, y, z), this.transformZ(x, y, z));
    }

    public int transformX(Vector3i vector) {
        return this.transformX(vector.getX(), vector.getY(), vector.getZ());
    }

    public int transformX(int x, int y, int z) {
        return GenericMath.floor((double)(this.matrixRow0.dot((float)x, (float)y, (float)z, 1.0f) + (double)GenericMath.FLT_EPSILON));
    }

    public int transformY(Vector3i vector) {
        return this.transformY(vector.getX(), vector.getY(), vector.getZ());
    }

    public int transformY(int x, int y, int z) {
        return GenericMath.floor((double)(this.matrixRow1.dot((float)x, (float)y, (float)z, 1.0f) + (double)GenericMath.FLT_EPSILON));
    }

    public int transformZ(Vector3i vector) {
        return this.transformZ(vector.getX(), vector.getY(), vector.getZ());
    }

    public int transformZ(int x, int y, int z) {
        return GenericMath.floor((double)(this.matrixRow2.dot((float)x, (float)y, (float)z, 1.0f) + (double)GenericMath.FLT_EPSILON));
    }

    public DiscreteTransform3 invert() {
        return new DiscreteTransform3(this.matrix.invert());
    }

    public DiscreteTransform3 compose(DiscreteTransform3 that) {
        return new DiscreteTransform3(this.matrix.mul(that.matrix));
    }

    public DiscreteTransform3 andThen(DiscreteTransform3 that) {
        return that.compose(this);
    }

    public DiscreteTransform3 withTranslation(Vector3i vector) {
        return this.withTranslation(vector.getX(), vector.getY(), vector.getZ());
    }

    public DiscreteTransform3 withTranslation(int x, int y, int z) {
        return new DiscreteTransform3(this.matrix.translate((float)x, (float)y, (float)z));
    }

    public DiscreteTransform3 withScale(int a) {
        return this.withScale(a, a, a);
    }

    public DiscreteTransform3 withScale(Vector3i vector) {
        return this.withScale(vector.getX(), vector.getY(), vector.getZ());
    }

    public DiscreteTransform3 withScale(int x, int y, int z) {
        Preconditions.checkArgument((x != 0 ? 1 : 0) != 0, (Object)"x == 0");
        Preconditions.checkArgument((y != 0 ? 1 : 0) != 0, (Object)"y == 0");
        Preconditions.checkArgument((z != 0 ? 1 : 0) != 0, (Object)"z == 0");
        return new DiscreteTransform3(this.matrix.scale((float)x, (float)y, (float)z, 1.0f));
    }

    public DiscreteTransform3 withRotation(int quarterTurns, Axis axis) {
        return new DiscreteTransform3(this.matrix.rotate(Quaterniond.fromAngleDegAxis((float)(quarterTurns * 90), (Vector3d)axis.toVector3d())));
    }

    public DiscreteTransform3 withRotation(int quarterTurns, Axis axis, Vector3i point, boolean blockCorner) {
        Vector3d pointDouble = point.toDouble();
        if (blockCorner) {
            pointDouble = pointDouble.add(0.5, 0.5, 0.5);
        }
        return new DiscreteTransform3(this.matrix.translate(pointDouble.negate()).rotate(Quaterniond.fromAngleDegAxis((float)(quarterTurns * 90), (Vector3d)axis.toVector3d())).translate(pointDouble));
    }

    public DiscreteTransform3 withRotation(int halfTurns, Axis axis, Vector3i point, boolean blockCornerX, boolean blockCornerY, boolean blockCornerZ) {
        Vector3d pointDouble = point.toDouble();
        if (blockCornerX) {
            pointDouble = pointDouble.add(0.5, 0.0, 0.0);
        }
        if (blockCornerY) {
            pointDouble = pointDouble.add(0.0, 0.5, 0.0);
        }
        if (blockCornerZ) {
            pointDouble = pointDouble.add(0.0, 0.0, 0.5);
        }
        return new DiscreteTransform3(this.matrix.translate(pointDouble.negate()).rotate(Quaterniond.fromAngleDegAxis((float)(halfTurns * 180), (Vector3d)axis.toVector3d())).translate(pointDouble));
    }

    public DiscreteTransform3 withTransformation(DiscreteTransform3 transform) {
        return new DiscreteTransform3(transform.getMatrix().mul(this.getMatrix()));
    }

    public static Optional<DiscreteTransform3> of(Matrix4d matrix) {
        if (Arrays.stream(matrix.toArray()).anyMatch(value -> Math.rint(value) != value)) {
            return Optional.empty();
        }
        return Optional.of(new DiscreteTransform3(matrix));
    }

    public static DiscreteTransform3 fromTranslation(Vector3i vector) {
        return DiscreteTransform3.fromTranslation(vector.getX(), vector.getY(), vector.getZ());
    }

    public static DiscreteTransform3 fromTranslation(int x, int y, int z) {
        return new DiscreteTransform3(Matrix4d.createTranslation((float)x, (float)y, (float)z));
    }

    public static DiscreteTransform3 fromScale(int a) {
        return DiscreteTransform3.fromScale(a, a, a);
    }

    public static DiscreteTransform3 fromScale(Vector3i vector) {
        return DiscreteTransform3.fromScale(vector.getX(), vector.getY(), vector.getZ());
    }

    public static DiscreteTransform3 fromScale(int x, int y, int z) {
        Preconditions.checkArgument((x != 0 ? 1 : 0) != 0, (Object)"x == 0");
        Preconditions.checkArgument((y != 0 ? 1 : 0) != 0, (Object)"y == 0");
        Preconditions.checkArgument((z != 0 ? 1 : 0) != 0, (Object)"z == 0");
        return new DiscreteTransform3(Matrix4d.createScaling((float)x, (float)y, (float)z, (float)1.0f));
    }

    public static DiscreteTransform3 fromRotation(int quarterTurns, Axis axis) {
        return new DiscreteTransform3(Matrix4d.createRotation((Quaterniond)Quaterniond.fromAngleDegAxis((float)(quarterTurns * 90), (Vector3d)axis.toVector3d())));
    }

    public static DiscreteTransform3 fromRotation(int quarterTurns, Axis axis, Vector3i point, boolean blockCorner) {
        Vector3d pointDouble = point.toDouble();
        if (blockCorner) {
            pointDouble = pointDouble.add(0.5, 0.5, 0.5);
        }
        return new DiscreteTransform3(Matrix4d.createTranslation((Vector3d)pointDouble.negate()).rotate(Quaterniond.fromAngleDegAxis((float)(quarterTurns * 90), (Vector3d)axis.toVector3d())).translate(pointDouble));
    }

    public static DiscreteTransform3 fromRotation(int halfTurns, Axis axis, Vector3i point, boolean blockCornerX, boolean blockCornerY, boolean blockCornerZ) {
        Vector3d pointDouble = point.toDouble();
        if (blockCornerX) {
            pointDouble = pointDouble.add(0.5, 0.0, 0.0);
        }
        if (blockCornerY) {
            pointDouble = pointDouble.add(0.0, 0.5, 0.0);
        }
        if (blockCornerZ) {
            pointDouble = pointDouble.add(0.0, 0.0, 0.5);
        }
        return new DiscreteTransform3(Matrix4d.createTranslation((Vector3d)pointDouble.negate()).rotate(Quaterniond.fromAngleDegAxis((float)(halfTurns * 180), (Vector3d)axis.toVector3d())).translate(pointDouble));
    }

    public static DiscreteTransform3 rotationAroundCenter(int quarterTurns, Axis axis, Vector3i size) {
        Matrix4d rotation3;
        Preconditions.checkArgument((size.getX() > 0 ? 1 : 0) != 0, (Object)"The size on x must be positive");
        Preconditions.checkArgument((size.getY() > 0 ? 1 : 0) != 0, (Object)"The size on y must be positive");
        Preconditions.checkArgument((size.getZ() > 0 ? 1 : 0) != 0, (Object)"The size on z must be positive");
        switch (axis) {
            case X: {
                Matrix3d rotation2 = DiscreteTransform2.rotationAroundCenter(quarterTurns, new Vector2i(size.getZ(), size.getY())).getMatrix();
                rotation3 = new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, rotation2.get(1, 0), rotation2.get(1, 1), rotation2.get(1, 2), 0.0, rotation2.get(0, 0), rotation2.get(0, 1), rotation2.get(0, 2), 0.0, 0.0, 0.0, 1.0);
                break;
            }
            case Y: {
                Matrix3d rotation2 = DiscreteTransform2.rotationAroundCenter(quarterTurns, new Vector2i(size.getX(), size.getZ())).getMatrix();
                rotation3 = new Matrix4d(rotation2.get(0, 0), 0.0, rotation2.get(0, 1), rotation2.get(0, 2), 0.0, 1.0, 0.0, 0.0, rotation2.get(1, 0), 0.0, rotation2.get(1, 1), rotation2.get(1, 2), 0.0, 0.0, 0.0, 1.0);
                break;
            }
            case Z: {
                Matrix3d rotation2 = DiscreteTransform2.rotationAroundCenter(quarterTurns, new Vector2i(size.getX(), size.getY())).getMatrix();
                rotation3 = new Matrix4d(rotation2.get(0, 0), rotation2.get(0, 1), 0.0, rotation2.get(0, 2), rotation2.get(1, 0), rotation2.get(1, 1), 0.0, rotation2.get(1, 2), 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
                break;
            }
            default: {
                throw new UnsupportedOperationException(axis.name());
            }
        }
        return new DiscreteTransform3(rotation3);
    }
}

