/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util.generator.event.factory;

import com.google.common.base.Preconditions;
import java.util.List;
import org.spongepowered.api.util.generator.GeneratorUtils;
import org.spongepowered.api.util.generator.event.factory.ClassGenerator;
import org.spongepowered.api.util.generator.event.factory.EventFactory;
import org.spongepowered.api.util.generator.event.factory.FactoryProvider;
import org.spongepowered.api.util.generator.event.factory.NullPolicy;
import org.spongepowered.api.util.generator.event.factory.plugin.EventFactoryPlugin;

public class ClassGeneratorProvider
implements FactoryProvider {
    private final GeneratorUtils.LocalClassLoader classLoader = new GeneratorUtils.LocalClassLoader(ClassGeneratorProvider.class.getClassLoader());
    private final ClassGenerator builder = new ClassGenerator();
    private final String targetPackage;

    public ClassGeneratorProvider(String targetPackage) {
        Preconditions.checkNotNull((Object)targetPackage, (Object)"targetPackage");
        this.targetPackage = targetPackage;
    }

    @Override
    public NullPolicy getNullPolicy() {
        return this.builder.getNullPolicy();
    }

    @Override
    public void setNullPolicy(NullPolicy nullPolicy) {
        this.builder.setNullPolicy(nullPolicy);
    }

    protected String getClassName(Class<?> clazz, String classifier) {
        String name = clazz.getSimpleName();
        while (clazz.getEnclosingClass() != null) {
            clazz = clazz.getEnclosingClass();
            name = clazz.getSimpleName() + "$" + name;
        }
        return this.targetPackage + "." + name + "$" + classifier;
    }

    @Override
    public <T> EventFactory<T> create(Class<T> type, Class<?> parentType, List<? extends EventFactoryPlugin> plugins) {
        String eventName = this.getClassName(type, "Impl");
        String factoryName = this.getClassName(type, "Factory");
        Class<?> eventClass = this.classLoader.defineClass(eventName, this.builder.createClass(type, eventName, parentType, plugins));
        Class<?> factoryClass = this.classLoader.defineClass(factoryName, this.builder.createFactory(eventClass, factoryName));
        try {
            return (EventFactory)factoryClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to create event factory", e);
        }
    }
}

