/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import com.google.common.base.Objects;

public enum BlockChangeFlag {
    ALL(6),
    NEIGHBOR(2),
    PHYSICS(4),
    NEIGHBOR_PHYSICS(6),
    NONE;

    private final boolean updateNeighbors;
    private final boolean performBlockPhysics;
    private final int rawFlag;

    private BlockChangeFlag() {
        this.updateNeighbors = false;
        this.performBlockPhysics = false;
        this.rawFlag = 0;
    }

    private BlockChangeFlag(int flag) {
        this.updateNeighbors = (flag & 2) != 0;
        this.performBlockPhysics = (flag & 4) != 0;
        this.rawFlag = flag;
    }

    public boolean updateNeighbors() {
        return this.updateNeighbors;
    }

    public boolean performBlockPhysics() {
        return this.performBlockPhysics;
    }

    public BlockChangeFlag setUpdateNeighbors(boolean updateNeighbors) {
        if (this.updateNeighbors == updateNeighbors) {
            return this;
        }
        int maskedFlag = (updateNeighbors ? 2 : 0) | (this.performBlockPhysics ? 4 : 0);
        for (BlockChangeFlag blockChangeFlag : BlockChangeFlag.values()) {
            if (blockChangeFlag.rawFlag != maskedFlag) continue;
            return blockChangeFlag;
        }
        return this;
    }

    public BlockChangeFlag setPerformBlockPhysics(boolean performBlockPhysics) {
        if (this.performBlockPhysics == performBlockPhysics) {
            return this;
        }
        int maskedFlag = (this.updateNeighbors ? 2 : 0) | (performBlockPhysics ? 4 : 0);
        for (BlockChangeFlag blockChangeFlag : BlockChangeFlag.values()) {
            if (blockChangeFlag.rawFlag != maskedFlag) continue;
            return blockChangeFlag;
        }
        return this;
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("updateNeighbors", this.updateNeighbors).add("performBlockPhysics", this.performBlockPhysics).toString();
    }

    static final class Flags {
        private static final int NEIGHBOR_MASK = 2;
        private static final int PHYSICS_MASK = 4;

        Flags() {
        }
    }
}

