/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.world.World;

public interface ChunkTicketManager {
    public void registerCallback(Object var1, Callback var2);

    public Optional<LoadingTicket> createTicket(Object var1, World var2);

    public Optional<EntityLoadingTicket> createEntityTicket(Object var1, World var2);

    public Optional<PlayerLoadingTicket> createPlayerTicket(Object var1, World var2, UUID var3);

    public Optional<PlayerEntityLoadingTicket> createPlayerEntityTicket(Object var1, World var2, UUID var3);

    public int getMaxTickets(Object var1);

    public int getAvailableTickets(Object var1, World var2);

    public int getAvailableTickets(UUID var1);

    public ImmutableSetMultimap<Vector3i, LoadingTicket> getForcedChunks(World var1);

    public static interface PlayerOrderedCallback
    extends Callback {
        public ListMultimap<UUID, LoadingTicket> onPlayerLoaded(ImmutableListMultimap<UUID, LoadingTicket> var1, World var2);
    }

    public static interface OrderedCallback
    extends Callback {
        public List<LoadingTicket> onLoaded(ImmutableList<LoadingTicket> var1, World var2, int var3);
    }

    @FunctionalInterface
    public static interface Callback {
        public void onLoaded(ImmutableList<LoadingTicket> var1, World var2);
    }

    public static interface PlayerEntityLoadingTicket
    extends PlayerLoadingTicket,
    EntityLoadingTicket {
    }

    public static interface EntityLoadingTicket
    extends LoadingTicket {
        public void bindToEntity(Entity var1);

        public Entity getBoundEntity();
    }

    public static interface PlayerLoadingTicket
    extends LoadingTicket {
        public UUID getPlayerUniqueId();
    }

    public static interface LoadingTicket {
        public boolean setNumChunks(int var1);

        public int getNumChunks();

        public int getMaxNumChunks();

        public String getPlugin();

        public ImmutableSet<Vector3i> getChunkList();

        public void forceChunk(Vector3i var1);

        public void unforceChunk(Vector3i var1);

        public void prioritizeChunk(Vector3i var1);

        public void release();
    }
}

