/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import java.util.Collection;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.registry.CatalogTypeAlreadyRegisteredException;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.util.annotation.CatalogedBy;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.GeneratorType;
import org.spongepowered.api.world.PortalAgentType;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.WorldArchetypes;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.gen.WorldGeneratorModifier;
import org.spongepowered.api.world.storage.WorldProperties;

@CatalogedBy(value={WorldArchetypes.class})
public interface WorldArchetype
extends CatalogType {
    public static Builder builder() {
        return Sponge.getGame().getRegistry().createBuilder(Builder.class);
    }

    public boolean isEnabled();

    public boolean loadOnStartup();

    public boolean doesKeepSpawnLoaded();

    public boolean doesGenerateSpawnOnLoad();

    public long getSeed();

    public GameMode getGameMode();

    public GeneratorType getGeneratorType();

    public Collection<WorldGeneratorModifier> getGeneratorModifiers();

    public boolean usesMapFeatures();

    public boolean isHardcore();

    public boolean areCommandsAllowed();

    public boolean doesGenerateBonusChest();

    public DimensionType getDimensionType();

    public PortalAgentType getPortalAgentType();

    public Difficulty getDifficulty();

    public boolean isPVPEnabled();

    public DataContainer getGeneratorSettings();

    public SerializationBehavior getSerializationBehavior();

    public static interface Builder
    extends ResettableBuilder<WorldArchetype, Builder> {
        public Builder enabled(boolean var1);

        public Builder loadsOnStartup(boolean var1);

        public Builder keepsSpawnLoaded(boolean var1);

        public Builder generateSpawnOnLoad(boolean var1);

        public Builder seed(long var1);

        public Builder gameMode(GameMode var1);

        public Builder generator(GeneratorType var1);

        public Builder generatorModifiers(WorldGeneratorModifier ... var1);

        public Builder dimension(DimensionType var1);

        public Builder difficulty(Difficulty var1);

        public Builder usesMapFeatures(boolean var1);

        public Builder hardcore(boolean var1);

        public Builder generatorSettings(DataContainer var1);

        public Builder portalAgent(PortalAgentType var1);

        public Builder pvp(boolean var1);

        public Builder commandsAllowed(boolean var1);

        public Builder generateBonusChest(boolean var1);

        public Builder serializationBehavior(SerializationBehavior var1);

        @Override
        public Builder from(WorldProperties var1);

        public WorldArchetype build(String var1, String var2) throws IllegalArgumentException, CatalogTypeAlreadyRegisteredException;
    }
}

