/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.biome;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.function.Function;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.util.weighted.SeededVariableAmount;
import org.spongepowered.api.util.weighted.VariableAmount;

public class GroundCoverLayer {
    private Function<Double, BlockState> block;
    private SeededVariableAmount<Double> depth;

    public GroundCoverLayer(BlockState block, SeededVariableAmount<Double> depth) {
        this((Double s) -> block, depth);
    }

    public GroundCoverLayer(Function<Double, BlockState> block, SeededVariableAmount<Double> depth) {
        this.block = (Function)Preconditions.checkNotNull(block, (Object)"block");
        this.depth = (SeededVariableAmount)Preconditions.checkNotNull(depth, (Object)"depth");
    }

    public Function<Double, BlockState> getBlockState() {
        return this.block;
    }

    public void setBlockState(Function<Double, BlockState> block) {
        this.block = (Function)Preconditions.checkNotNull(block, (Object)"block");
    }

    public void setBlockState(BlockState block) {
        Preconditions.checkNotNull((Object)block);
        this.block = s -> block;
    }

    public SeededVariableAmount<Double> getDepth() {
        return this.depth;
    }

    public void setDepth(SeededVariableAmount<Double> depth) {
        this.depth = (SeededVariableAmount)Preconditions.checkNotNull(depth, (Object)"depth");
    }

    public void setDepth(VariableAmount depth) {
        this.depth = SeededVariableAmount.wrapped((VariableAmount)Preconditions.checkNotNull((Object)depth, (Object)"depth"));
    }

    public void setDepth(double depth) {
        this.depth = SeededVariableAmount.fixed(depth);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("block", this.block).add("depth", this.depth).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GroundCoverLayer)) {
            return false;
        }
        GroundCoverLayer object = (GroundCoverLayer)obj;
        if (!this.depth.equals(object.depth)) {
            return false;
        }
        return this.block.equals(object.block);
    }

    public int hashCode() {
        int result = 1;
        result = 37 * result + this.block.hashCode();
        result = 37 * result + this.depth.hashCode();
        return result;
    }
}

