/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.extent;

import com.flowpowered.math.vector.Vector3i;
import org.spongepowered.api.util.DiscreteTransform3;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.extent.ImmutableBiomeVolume;
import org.spongepowered.api.world.extent.MutableBiomeVolume;
import org.spongepowered.api.world.extent.StorageType;
import org.spongepowered.api.world.extent.UnmodifiableBiomeVolume;
import org.spongepowered.api.world.extent.worker.BiomeVolumeWorker;

public interface BiomeVolume {
    public Vector3i getBiomeMin();

    public Vector3i getBiomeMax();

    public Vector3i getBiomeSize();

    default public boolean containsBiome(Vector3i position) {
        return this.containsBiome(position.getX(), position.getY(), position.getZ());
    }

    public boolean containsBiome(int var1, int var2, int var3);

    default public BiomeType getBiome(Vector3i position) {
        return this.getBiome(position.getX(), position.getY(), position.getZ());
    }

    public BiomeType getBiome(int var1, int var2, int var3);

    public BiomeVolume getBiomeView(Vector3i var1, Vector3i var2);

    public BiomeVolume getBiomeView(DiscreteTransform3 var1);

    default public BiomeVolume getRelativeBiomeView() {
        return this.getBiomeView(DiscreteTransform3.fromTranslation(this.getBiomeMin().negate()));
    }

    public UnmodifiableBiomeVolume getUnmodifiableBiomeView();

    default public MutableBiomeVolume getBiomeCopy() {
        return this.getBiomeCopy(StorageType.STANDARD);
    }

    public MutableBiomeVolume getBiomeCopy(StorageType var1);

    public ImmutableBiomeVolume getImmutableBiomeCopy();

    public BiomeVolumeWorker<? extends BiomeVolume> getBiomeWorker();
}

