/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.gen.populator;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.type.DoublePlantType;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.Populator;

public interface DoublePlant
extends Populator {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public WeightedTable<DoublePlantType> getPossibleTypes();

    public VariableAmount getPlantsPerChunk();

    public void setPlantsPerChunk(VariableAmount var1);

    default public void setPlantsPerChunk(int count) {
        this.setPlantsPerChunk(VariableAmount.fixed(count));
    }

    public Optional<Function<Location<Extent>, DoublePlantType>> getSupplierOverride();

    public void setSupplierOverride(@Nullable Function<Location<Extent>, DoublePlantType> var1);

    default public void clearSupplierOverride() {
        this.setSupplierOverride(null);
    }

    public static interface Builder
    extends ResettableBuilder<DoublePlant, Builder> {
        public Builder types(WeightedTable<DoublePlantType> var1);

        public Builder type(DoublePlantType var1, double var2);

        public Builder perChunk(VariableAmount var1);

        default public Builder perChunk(int count) {
            return this.perChunk(VariableAmount.fixed(count));
        }

        public Builder supplier(@Nullable Function<Location<Extent>, DoublePlantType> var1);

        public DoublePlant build() throws IllegalStateException;
    }
}

