/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.gen.populator;

import org.spongepowered.api.Sponge;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.Populator;

public interface IceSpike
extends Populator {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public VariableAmount getSpikesPerChunk();

    public void setSpikesPerChunk(VariableAmount var1);

    default public void setSpikesPerChunk(int count) {
        this.setSpikesPerChunk(VariableAmount.fixed(count));
    }

    public VariableAmount getHeight();

    public void setHeight(VariableAmount var1);

    default public void setHeight(int height) {
        this.setHeight(VariableAmount.fixed(height));
    }

    public double getExtremeSpikeProbability();

    public void setExtremeSpikeProbability(double var1);

    public VariableAmount getExtremeSpikeIncrease();

    public void setExtremeSpikeIncrease(VariableAmount var1);

    default public void setExtremeSpikeIncrease(int increase) {
        this.setExtremeSpikeIncrease(VariableAmount.fixed(increase));
    }

    public static interface Builder
    extends ResettableBuilder<IceSpike, Builder> {
        public Builder spikesPerChunk(VariableAmount var1);

        default public Builder spikesPerChunk(int count) {
            return this.spikesPerChunk(VariableAmount.fixed(count));
        }

        public Builder height(VariableAmount var1);

        default public Builder height(int height) {
            return this.height(VariableAmount.fixed(height));
        }

        public Builder extremeSpikeProbability(double var1);

        public Builder extremeSpikeIncrease(VariableAmount var1);

        default public Builder extremeSpikeIncrease(int increase) {
            return this.extremeSpikeIncrease(VariableAmount.fixed(increase));
        }

        public IceSpike build() throws IllegalStateException;
    }
}

